@csrf
<div class="form-group">
    <label for="produce-name">Name</label>
    <input type="text" name="name" id="produce-name" value="{{ old('name', $produce->name ?? '') }}" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="Produce Name">

    @if ($errors->has('name'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('name') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    @php $selectedvalue = old('category_id', $produce->category_id ?? '') @endphp

    <label for="produce-category_id">Category</label>
    <select id="produce-category_id" name="category_id" style="width: 100%; border-color: #ebedf2;">
            <option value="">--Select--</option>
            @foreach($categories as $category)
                <option value="{{ $category->id }}" {{ $selectedvalue == $category->id ? 'selected="selected"' : '' }}>{{ sprintf('%s', $category->name) }}</option>
            @endforeach
        </select>

    @if ($errors->has('category_id'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('category_id') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    @php $selectedvalue = old('listed', $produce->listed ?? '') @endphp

    <label for="produce-listed">Listed?</label>
    <select name="listed" id="produce-listed" class="form-control">
        <option value="">- Select -</option>
        <option value="0" {{ $selectedvalue == 0 ? 'selected="selected"' : '' }}>No</option>
        <option value="1" {{ $selectedvalue == 1 ? 'selected="selected"' : '' }}>Yes</option>
    </select>

    @if ($errors->has('listed'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('listed') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="produce-description">Description</label>
    <textarea name="description" id="produce-description" class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}" rows="10">{{ old('description', $produce->description ?? '') }}</textarea>

    @if ($errors->has('description'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('description') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">{{ $buttonText }}</button>
</div>
