@csrf
<div class="form-group">
    <label for="name">Name</label>
    <input type="text" name="name" id="name" value="{{ old('name', $produce_unit->name ?? '') }}" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="Produce Unit">

    @if ($errors->has('name'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('name') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="abbreviation">Abbreviation</label>
    <input type="text" name="abbreviation" id="abbreviation" value="{{ old('abbreviation', $produce_unit->abbreviation ?? '') }}" class="form-control {{ $errors->has('abbreviation') ? 'is-invalid' : '' }}" placeholder="Abbreviation">

    @if ($errors->has('abbreviation'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('abbreviation') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="region-description">Description</label>
    <textarea name="description" id="description" class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}" rows="10">{{ old('description', $produce_unit->description ?? '') }}</textarea>

    @if ($errors->has('description'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('description') }}</strong>
        </div>
    @endif
</div>
@if( isset($buttonText) )
    <div class="form-group">
        <button type="submit" class="btn btn-primary btn-lg">{{ $buttonText }}</button>
    </div>
@endif
