@extends('layouts.site')

@section('title')
BTCotton | Produce Collection - {{ 'ID: ' . $produce_order->id }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Produce Collection - {{ 'ID: ' . $produce_order->id }}</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Produce Collection</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="edit-produce-order" href="#" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Update Produce Collection
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <p>
                        <b>Produce Collection ID:</b> {{ $produce_order->id }}
                        <br><b>Organisation:</b> {{ $produce_order->trader->organisation_name }}
                        <br><b>No of Items:</b> {{ $produce_order->produce_order_items->count() }}
                        <br><b>Total:</b> {{ 'KSh ' . number_format($produce_order->total, 2) }}
                        <br><b>Approved:</b> {{ $produce_order->approved ? 'Yes' : 'No' }}
                    </p>
                    <hr>

                    @if($produce_order->produce_order_items->count())
                        @include('produce-order-items._index')
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
