<div class="table-responsive">
    <table id="produce-order-items-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th></th>
                <th>Produce</th>
                <th>Quantity</th>
                <th>Price per Unit (KSh)</th>
                <th class="text-center" style="width: 10%">Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th></th>
                <th>Produce</th>
                <th>Quantity</th>
                <th>Price per Unit (KSh)</th>
                <th class="text-center">Action</th>
            </tr>
        </tfoot>
        <tbody id="produce-order-item-list">
            @foreach($produce_order->produce_order_items as $produce_order_item)
                <tr id="produce_order_item_id{{ $produce_order_item->id }}">
                    <td class="details-control" data-id="{{ $produce_order_item->id }}"></td>
                    <td>
                        <a href="{{ $produce_order_item->contract_detail->url }}">{{ $produce_order_item->contract_detail->produce_item->name }}</a>
                        <br><small><b>Produce:</b> {{ $produce_order_item->contract_detail->produce_item->produce->name }} | <b>Units:</b> {{ $produce_order_item->contract_detail->produce_item->produce_unit->name }}</small>
                    </td>
                    <td>{{ $produce_order_item->quantity }}</td>
                    <td>{{ number_format($produce_order_item->price_per_unit, 2) }}</td>
                    <td>
                        <div class="btn-group form-actions" role="group" aria-label="Actions">
                            <button id="edit-produce-order-item" type="button" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $produce_order_item->id }}">
                                <i class="fa fa-edit"></i> Edit
                            </button>
                            <button id="delete-produce-order-item" type="button" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $produce_order_item->id }}">
                                <i class="far fa-trash-alt"></i> Delete
                            </button>
                            @if(!$produce_order_item->approved)
                            <form name="form1" action="{{ route('collections.index')}}" method="post">
                            @csrf
                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                            <input type="hidden" name="id" value="{{ $produce_order_item->id }}">
                            <input type="hidden" name="contract_detail_id" value="{{ $produce_order_item->contract_detail_id }}">
                            <button type="submit" class="btn btn-info btn-sm" data-toggle="tooltip" title="Collect Items" data-original-title="Collect Items" >
                                <a href="{{ route('collections.index')}}?id={{ $produce_order_item->id }}&&contract_detail_id={{ $produce_order_item->contract_detail_id }}"><i class="far fa-check"></i> Collect</a>
                            </button>
                            </form>
                            @endif
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
