@extends('layouts.site')

@section('title')
BTCotton | Add / Remove Produce Stock
@endsection

@section('header')
<div class="page-header">
    <h4 class="page-title">Add/ Remove Produce Stock</h4>
    {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
    <ul class="breadcrumbs">
        <li class="nav-home">
            <a href="#">
                <i class="flaticon-home"></i>
            </a>
        </li>
        <li class="separator">
            <i class="flaticon-right-arrow"></i>
        </li>
        <li class="nav-item">
            <a href="#">Items</a>
        </li>
        {{-- <li class="separator">
            <i class="flaticon-right-arrow"></i>
        </li>
        <li class="nav-item">
            <a href="#">Buttons</a>
        </li> --}}
    </ul>
</div>
<div class="ml-md-auto py-2 py-md-0">
    <a href="{{ URL::previous() }}" class="btn btn-white btn-round ml-1">
        <i class="fas fa-caret-left"></i> Back
    </a>
</div>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                @include ('layouts._messages')
                <div class="row">
                    <div class="col-md-8">
                        <form action="{{ route('stock.update',$item->id) }}" method="post">
                            @csrf
                            <div class="form-group">
                                <label for="operation">Operation</label>
                                <select id="operation" name="operation" class="form-control">
                                    <option value="">--Select--</option>
                                    <option value="add" {{old('operation','')=='add'?'selected':''}}>Add Stock</option>
                                    <option value="remove" {{old('operation','')=='remove'?'selected':''}}>Remove Stock</option>
                                </select>
                                @if ($errors->has('operation'))
                                <div class="invalid-feedback">
                                    <strong>{{ $errors->first('operation') }}</strong>
                                </div>
                                @endif
                            </div>
                            <div class="form-group">
                                <label for="item-farmer_id">Farmer</label>
                                <select id="item-farmer_id" name="farmer_id" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">--Select--</option>
                                    @foreach($traders as $trader)
                                        <option value="{{ $trader->id }}">{{ sprintf('%s %s', $trader->user->firstname, $trader->user->lastname) }}</option>
                                    @endforeach
                                </select>

                                @if ($errors->has('trader_id'))
                                    <div class="invalid-feedback">
                                        <strong>{{ $errors->first('trader_id') }}</strong>
                                    </div>
                                @endif
                            </div>
                            <div class="form-group">
                                <label for="item-amount">Quantity</label>
                                <input type="number" name="amount" id="item-amount" value="{{ old('amount', '' ?? '') }}" class="form-control {{ $errors->has('amount') ? 'is-invalid' : '' }}" placeholder="Quantity">

                                @if ($errors->has('amount'))
                                <div class="invalid-feedback">
                                    <strong>{{ $errors->first('amount') }}</strong>
                                </div>
                                @endif
                            </div>
                            <div class="form-group">
                                <label for="item-price">Price</label>
                                <input type="number" name="price" id="item-price" value="{{ old('price', '' ?? '') }}" class="form-control {{ $errors->has('price') ? 'is-invalid' : '' }}" placeholder="Price">

                                @if ($errors->has('price'))
                                <div class="invalid-feedback">
                                    <strong>{{ $errors->first('price') }}</strong>
                                </div>
                                @endif
                            </div>
                            <div class="form-group">
                                <label for="product-description">Note</label>
                                <textarea name="description" id="product-description" class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}">{{ old('description', $product->description ?? '') }}</textarea>

                                @if ($errors->has('description'))
                                <div class="invalid-feedback">
                                    <strong>{{ $errors->first('description') }}</strong>
                                </div>
                                @endif
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary btn-lg">Update Stock</button>
                            </div>

                        </form>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title">Update Inventory</h5>
                            </div>
                            <div class="card-body">
                                <p class="card-text">
                                    <b>Organisation:</b> {{ $item->trader->organization_name}}<br>
                                    <b>Product:</b> {{ $item->product->name }}<br>
                                    <b>Units:</b> {{ $item->unit->name }}<br>
                                    <b>Current Stock:</b> {{ $item->amount }}
                                </p>
                                {{-- <a href="#" class="card-link">Card link</a>
                                <a href="#" class="card-link">Another link</a> --}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function () {
        $('#produceitem-farmer_id').select2();
    });
</script>
@endsection
