@extends('layouts.site')

@section('title')
BTCotton | Produce Inventory Item - {{ $produceitem->product->name }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Item - {{ $produceitem->product->name }}</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Items</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        {{-- <a href="{{ route('produce-items.create') }}" class="btn btn-primary btn-round" data-toggle="modal" data-target="#addRowModal"> --}}
        <a href="{{ route('produce-items.edit', $item->id) }}" class="btn btn-primary btn-round">
            <i class="fa fa-edit"></i> Edit Item
        </a>
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <p><b>Product:</b> {{ $item->produce->name }}</p>
                    <p><b>Seller:</b> {{ $item->trader->user->fullname }}</p>
                    <p><b>Unit:</b> {{ $item->unit }}</p>
                    <p><b>Price per unit:</b> {{ $item->price_per_unit }}</p>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
