<div class="table-responsive">
    <table id="produce-items-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>ID</th>
                <th>Produce</th>
                <th>Balance</th>
                <th class="text-center">Listed?</th>
                @if(Auth::user()->isAdmin())
                    <th class="text-right" style="width: 10%">Action</th>
                @endif
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>ID</th>
                <th>Produce</th>
                <th>Balance</th>
                <th class="text-center">Listed?</th>
                @if(Auth::user()->isAdmin())
                    <th class="text-right">Action</th>
                @endif
            </tr>
        </tfoot>
        <tbody id="produce-item-list">
            @foreach($produce_items as $produce_item)
                <tr id="produce_item_id_{{ $produce_item->id }}">
                    <td>{{ $produce_item->id }}</td>
                    <td><h5>{{ $produce_item->produce->name }}</h5>
                        <b>Quality:</b> {{ $produce_item->quality }}
                        <br><b>Price:</b> {{ number_format($produce_item->price_per_unit, 2) .'/ '. $produce_item->produce_unit->abbreviation }}
                        <br><b>Tonnage:</b> {{ number_format($produce_item->tonnage) . ' Kgs' }}
                    </td>
                    <td>{{ number_format($produce_item->balance) }}</td>
                    <td class="text-center">{!! $produce_item->approved == 1 ? '<i class="fa fa-check"></i>' : '' !!}</td>
                    @if(Auth::user()->isAdmin())
                        <td class="text-right">
                            <div class="btn-group form-actions" role="group" aria-label="Actions">
                                <a id="edit-produce-item" href="{{ route('produce-items.edit', $produce_item->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $produce_item->id }}">
                                    <i class="fa fa-edit"></i> Edit
                                </a>
                                <button id="delete-produce" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $produce_item->id }}">
                                    <i class="far fa-trash-alt"></i> Delete
                                </button>
                            </div>
                        </td>
                    @endif
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
