@csrf
<div class="form-group">
    <label for="produce-item-name">Name</label>
    <input type="text" name="name" id="produce-item-name" value="{{ old('name', $produceitem->name ?? '') }}" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="Name">

    @if ($errors->has('name'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('name') }}</strong>
        </div>
    @endif
</div>
@if(! isset($item))
    <div class="form-group">
        <label for="item-trader">Organisation</label>
        <select id="item-trader" name="trader_id" style="width: 100%; border-color: #ebedf2;" class="form-control">
            <option value="">--Select--</option>
            @foreach($traders as $trader)
                <option value="{{ $trader->id }}">{{ sprintf('%s', $trader->organisation_name) }}</option>
            @endforeach
        </select>

        @if ($errors->has('trader_id'))
            <div class="invalid-feedback">
                <strong>{{ $errors->first('trader_id') }}</strong>
            </div>
        @endif
    </div>
    <div class="form-group">
        <label for="item-product">Product</label>
        <select id="item-product" name="product_id" style="width: 100%; border-color: #ebedf2;" class="form-control">
            <option value="">--Select--</option>
            @foreach($produces as $product)
            <option value="{{ $product->id }}">{{ sprintf('%s', $product->name) }}</option>
            @endforeach
        </select>

        @if ($errors->has('product_id'))
            <div class="invalid-feedback">
                <strong>{{ $errors->first('product_id') }}</strong>
            </div>
        @endif
    </div>
@endif
<div class="form-group">
    <label for="item-unit">Unit</label>
    <select name="unit" id="item-unit" class="form-control">
        <option value="">--Select--</option>
        @foreach ($produceunits as $unit)
            <option value="{{ $unit->id }} {{ old('unit', $item->unit ?? '') == $unit->id ? 'selected="selected"' : '' }}">{{ $unit->name }}</option>
        @endforeach
    </select>

    @if ($errors->has('unit'))
    <div class="invalid-feedback">
        <strong>{{ $errors->first('unit') }}</strong>
    </div>
    @endif
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">{{ $buttonText }}</button>
</div>
