@extends('layouts.site')

@section('title')
BTCotton | Invoices to pay Twalisha
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Produce Invoices</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($invoices->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>S/No.</th>
                                        <th>Invoice No.</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Item(s) </th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    @foreach($invoices as $invoice)
                                        <tr id="{{$invoice->id}}">
                                            <td><a href="#">{{ $invoice->id }}</a></td>
                                            <td>{{ $invoice->number }}</td>
                                            <td>{{ $invoice->total ? Str::limit($invoice->total,-2,'.') : '' }}</td>
                                            <td>{{ $invoice->balance ? Str::limit($invoice->balance,-2,'.') : '' }}</td>
                                            <td>{{ $invoice->invoiceproduce->contract_detail->produce_item->produce->name }}.<br>
                                            </td>
                                            <td>
                                            @if($invoice->status == 0)
                                            <span class="badge badge-danger">Pending</span>
                                            @elseif($invoice->status == 1)
                                             <span class="badge badge-warning">Paid</span>
                                             @elseif($invoice->status == 2)
                                             <span class="badge badge-success">Confirmed</span>
                                             @endif
                                            </td>
                                            <td>{{ Str::limit($invoice->created_at,10,'.') }}</td>
                                            <td class="text-right">
                                               <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                   <a href="{{ route('produce-invoices.show', $invoice->id)}}">
                                                    <button type="submit" class="btn btn-success btn-sm" data-toggle="tooltip" title="View" data-original-title="View">
                                                        <i class="fa fa-edit"></i> View
                                                    </button>
                                                    </a>
                                                    @if($invoice->status == 0)
                                                    <a href="#" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modal-default-{{$invoice->id}}">
                                                        <i class="fas fa-file-invoice-dollar"></i>Payments
                                                    </a>
                                                    @endif
                                    </tr>
                                        <!-- Modal -->
                                        <div class="modal fade" id="modal-default-{{ $invoice->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Pay Invoice Ref# {{$invoice->id}}</h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form method="post" action="{{ route('produce-invoices.store')}}">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                                                            <input type="hidden" name="approved" value="1">
                                                            <input type="hidden" name="id" value="{{$invoice->id}}">
                                                            <input type="hidden" name="total" value="{{$invoice->total}}">
                                                            <input type="hidden" name="balance" value="{{$invoice->balance}}">
                                                            <div class="form-group">
                                                            <label for="">Mode of Payment</label>
                                                                <input class="form-control" type="text" placeholder="e.g. cheque, cash..." name="mode">
                                                            <label for="">Amount</label>
                                                                <input class="form-control" type="number" name="amount">
                                                            <label for="">Date</label>
                                                                <input class="form-control" type="date" name="date" value="date()">

                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Pay Invoice</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                                    </div>

                                    </tr>

                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>S/No.</th>
                                        <th>Invoice No.</th>
                                        <th>Amount</th>
                                        <th>Balance</th>
                                        <th>Item(s) </th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>


        </div>
    </div>


@endsection
@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection
