@extends('layouts.site')

@section('title')
BTCotton | Produce Deliveries On Transit
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Produce Deliveries On Transit</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">On Transit</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        @if (isset($trader))
            <a href="" class="btn btn-primary btn-round btn-sm">
                <i class="fa fa-plus"></i>
            </a>
        @endif

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs.
                         <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    </div>

                @endif
                    @include ('layouts._messages')

                    @if($deliveries->count())
                        <div class="table-responsive">
                            <table  id="inputs-list" class="display table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>S/No</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Produce</th>
                                        <th>Driver</th>
                                        <th>Vehicle</th>
                                        <th>Dates</th>
                                        <th>Status</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                    <th>S/No</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Produce</th>
                                        <th>Driver</th>
                                        <th>Vehicle</th>
                                        <th>Dates</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    @foreach($deliveries as $delivery)
                                        <tr id="{{ $delivery->id }}">
                                            <td> {{ ++$i }}</td>

                                            <td>{{ $delivery->produce_collection->contract_detail->produce_item->trader->organisation_name }} </td>
                                            <td>{{ $delivery->produce_collection->contract_detail->contract->trader->organisation_name }}</td>
                                            <td>{{ $delivery->produce_collection->contract_detail->produce_item->produce->name }}
                                            <td>{{ $delivery->delivery->firstname }} {{ $delivery->delivery->lastname }}</td>
                                            <td>{{ $delivery->deliveries->make }} {{ $delivery->deliveries->plate }}</td>
                                            <td><b>Picking Date:</b> {{ Str::limit($delivery->deliveryRequests['picking_time'], 10,'.') }}<br>
                                            <b>Delivery Date:</b> {{ Str::limit($delivery->deliveryRequests['delivery_time'], 10,'.') }}</td>
                                            <td>
                                                @if($delivery->status == 3)
                                                   <span class="badge badge-success">Received</span>
                                                @elseif($delivery->status == 2)
                                                   <span class="badge badge-info">Completed</span>
                                                @elseif($delivery->status == 1)
                                                   <span class="badge badge-warning">In Process</span>
                                                @else
                                                   <span class="badge badge-danger">Pending</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                <button type="button" name="view" class="btn btn-success btn-sm" title="view" data-original-title="view" data-id=""data-toggle="modal" data-target="#modal-default-{{$delivery->id}}">
                                                        <i class="fa fa-check"></i> View
                                                    </button>
                                            </td>
                                            <!--Modal Confirm receipt-->
                                        <div class="modal fade" id="confirm-{{$delivery->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Confirm Receipt | Order Ref#{{ $delivery->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="confirm-receipt" method="post" action="{{ route('my-deliveries.store')}}">
                                                        @csrf

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                                                            <input type="hidden" name="trader_id" value="{{ $delivery->produce_collection->contract_detail->contract->trader_id }}">
                                                            <div class="form-group">
                                                                <label for="trader-id">State of produce at arrival</label>
                                                                <textarea class="form-control"name="state_of_arrival">
                                                                </textarea>
                                                                <label for="trader-id">Other Comments</label>
                                                                <textarea name="comment" class="form-control">
                                                                </textarea>

                                                                <input type="hidden" name="delivery_id" value="{{ $delivery->id }}">
                                                                <input type="hidden" name="status" value="3">
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="confirm-receipt" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal confirm receipt-->
                                            <!-- Modal view-->

                                        <div class="modal fade" id="modal-default-{{$delivery->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Delivery Details#{{ $delivery->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                   <div class="modal-body">

                                                   @if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isTransporter())
                                                   <h3>From: {{$delivery->produce_collection->contract_detail->produce_item->trader->organisation_name }}</h3>
                                                        <p>Located in: {{ $delivery->produce_collection->contract_detail->produce_item->trader->physical_address }}</p>
                                                        <p>Phone: 254{{ $delivery->produce_collection->contract_detail->produce_item->trader->phone }}</p>
                                                            <p>Email: {{ $delivery->produce_collection->contract_detail->produce_item->trader->email }}</p>
                                                        <h3>To: {{ $delivery->produce_collection->contract_detail->contract->trader->organisation_name }}</h3>
                                                        <p>Located in: {{ $delivery->produce_collection->contract_detail->contract->trader->physical_address }}</p>
                                                        <p>Phone: 254{{ $delivery->produce_collection->contract_detail->contract->trader->phone }}</p>
                                                        <p>Email: {{ $delivery->produce_collection->contract_detail->contract->trader->email }}</p>
                                                        @endif
                                                        <h3>Item Details</h3>
                                                        {{ $delivery->produce_collection->quantity }} Kgs. of {{ $delivery->produce_collection->contract_detail->produce_item->produce->name }}
                                                        @if($delivery->status == 3)
                                                        <h3>Acknowlegement</h3>
                                                        <p>State of goods: {!! $delivery->deliveryAcknowledgement[0]->state_of_arrival !!}</p>
                                                        <p>Other Comments: {!! $delivery->deliveryAcknowledgement[0]->comment !!}</p>
                                                        @endif
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end modal -->
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                              </tr>

                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>



@endsection

@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection
