@extends('layouts.admin')
@section('content')
<div id="app">
<div class="panel-header bg-primary-gradient">
    <div class="page-inner py-5">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
            <div>
                <h2 class="text-white pb-2 fw-bold">News </h2>
                <ul class="breadcrumbs text-white">
                    <li class="nav-home">
                        <a href="{{ route('content-creator.dashboard') }}" class="text-white">
                            <i class="flaticon-home"></i>
                        </a>
                    </li>
                    <li class="separator">
                        <i class="flaticon-right-arrow"></i>
                    </li>
                    <li class="nav-item">
                        <a href="" class="text-white">News</a>
                    </li>
                </ul>
            </div>
            <div class="ml-md-auto py-2 py-md-0">
                <button type="button" class="btn btn-white btn-round" data-toggle="modal" data-target="#add">
                    <i class="fa fa-plus"></i> Add News
                </button>
            </div>
        </div>
    </div>
</div>
<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-md-12">
            <div class="card full-height">
                <div class="card-body">
                    <div class="card-title">News</div>
                    @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <strong>Error! </strong>There were some errors with inputs.
                        <ul>
                            @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                        </ul>
                        </div>

                    @endif
                    <!-- table -->
                    <div class="table-responsive">
                        <table id="table" class="display table table-striped table-hover">
                            <thead>
                                <tr>
                                    <th>ID#</th>
                                    {{--<th>Category</th>--}}
                                    <th>Title</th>
                                    <th>News</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th class="text-right" style="width: 10%">Action</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th>ID#</th>
                                    {{--<th>Category</th>--}}
                                    <th>Title</th>
                                    <th>News</th>
                                    <th>Image</th>
                                    <th>Status</th>
                                    <th class="text-right" style="width: 10%">Action</th>
                                </tr>
                            </tfoot>
                            <tbody>
                                @foreach($news as $new)
                                <tr>
                                    <td>{{ $new->id }}</td>
                                    {{--<td>{{ $new->newsCategory->name }}</td>--}}
                                    <td>{{ $new->title }}</td>
                                    <td>{{ $new->content }}</td>
                                    <td>{{ $new->image }}</td>
                                    <td>@if($new->status == 0)
                                            <span class="badge badge-success">Active</span>
                                        @elseif($new->status ==  1)
                                            <span class="badge badge-danger">Stale</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="form-button-action" role="group">
                                            <button class="btn btn-sm btn-info" data-toggle="modal" data-target="#edit-{{ $new->id }}">Edit</button>
                                            <button name="delete" class="btn btn-sm btn-danger" @click='deleteItem("deletenews",{{ $new->id }})' type="submit">Delete</button>
                                        </div>
                                    </td>
                                    <div class="modal fade" id="edit-{{ $new->id }}" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog modal-lg" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">
                                                        Edit News
                                                    </h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body">
                                                    <edit-news :data="{{ json_encode($new) }}"></edit-news>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /end modal add news -->
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /end table -->
                    <!-- modal add news -->
                    <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">
                                        Add News
                                    </h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <add-news></add-news>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /end modal add news -->
                </div>
            </div>
        </div>
    </div>
</div>
</div>
@endsection