@extends('layouts.site')

@section('title')
BTCotton | Transport Requests
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Delivery Requests</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Delivery</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <!-- <a href="" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Delivery
        </a> -->
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs.
                         <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    </div>

                @endif
                    @include ('layouts._messages')

                    @if($requests->count())
                        <div class="table-responsive">
                            <table  id="inputs-list" class="display table table-striped table-hover">
                            <thead>
                                    <tr>
                                        <th>S/No</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Produce</th>
                                        <th>Status</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>S/No</th>
                                        <th>From</th>
                                        <th>To</th>
                                        <th>Produce</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    @foreach($requests as $request)
                                        <tr id="{{ $request->id }}">
                                            <td> {{ ++$i }}</td>
                                            <td>{{ $request->produce_collection->contract_detail->produce_item->trader->organisation_name ?? ''}} </td>
                                            <td>{{ $request->produce_collection->contract_detail->contract->trader->organisation_name ?? ''}}</td>
                                            <td>
                                                @if($request->produce_collection['contract_detail'])
                                                    {{ $request->produce_collection['contract_detail']->produce_item->produce->name ?? '' }}
                                                @endif
                                                <br><b>Quantity</b> {{ $request->produce_collection->quantity ?? '' . ' ' . $request->produce_collection['contract_detail']['produce_item']->produce_unit->abbreviation ?? '' }}
                                            </td>
                                            <td>@if($request->status == 1)
                                                   <span class="badge badge-success">Done</span>
                                                   @else
                                                   <span class="badge badge-danger">Pending</span>
                                                @endif </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <button type="button" name="view" class="btn btn-success btn-sm" title="view" data-original-title="view" data-id=""data-toggle="modal" data-target="#modal-default1-{{$request->id}}">
                                                        <i class="fa fa-check"></i> View
                                                    </button>
                                                    @if($request->status == 0)
                                                    <button type="button" class="btn btn-info btn-sm" title="Accept" data-original-title="Accept" data-id=""data-toggle="modal" data-target="#modal-default-{{$request->id}}">
                                                        <i class="fa fa-check"></i> Accept
                                                    </button>
                                                    @endif
                                                </div>

                                            </td>
                                            <!-- Modal Edit-->

                                        <div class="modal fade" id="modal-default-{{$request->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Delivery Ref#{{ $request->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="store" action="{{ route('my-delivery-requests.store')}}" method="post">
                                                    @csrf

                                                        <div class="modal-body">

                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">

                                                            <div class="form-group">

                                                                <label for="">Driver:</label>
                                                                <select class="form-control" name="driver_id" required>
                                                                <option value="">Select Driver</option>
                                                                @foreach($drivers as $driver)
                                                                <option value="{{ $driver->id }}">{{ $driver->firstname }} {{ $driver->lastname }}</option>
                                                                @endforeach
                                                                </select>
                                                                <label for="">Vehicle:</label>
                                                                <select class="form-control" name="vehicle_id">
                                                                <option value="">Select Vehicle</option>
                                                                @foreach($vehicles as $vehicle)
                                                                <option value="{{ $vehicle->id }}">{{ $vehicle->model }} - {{ $vehicle->plate }} (Capacity: {{ $vehicle->tonnage }})</option>
                                                                @endforeach
                                                                </select>
                                                                <input type="hidden" name="produce_collection_id" value="{{ $request->produce_collection->id }}">
                                                                <input type="hidden" name="delivery_request_id" value="{{ $request->id }}">
                                                                <input type="hidden" name="status" value="1">
                                                                <input type="hidden" name="from_id" value="{{ $request->produce_collection->contract_detail->produce_item->trader_id }}">
                                                                <input type="hidden" name="to_id" value="{{ $request->produce_collection->contract_detail->contract->trader_id }}">
                                                                {{-- <input type="hidden" name="transporter_id" value="{{ $request->transporter_id }}"> --}}
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="store" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Modal view-->

                                        <div class="modal fade" id="modal-default1-{{$request->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Delivery Details#{{ $request->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                   <div class="modal-body">

                                                        <h3>From: {{ $request->produce_collection->contract_detail->produce_item->trader->organisation_name }}</h3>
                                                        <p>Located in: {{ $request->produce_collection->contract_detail->produce_item->trader->physical_address }}|
                                                         Phone: 254{{ $request->produce_collection->contract_detail->produce_item->trader->phone }} |
                                                         Email: {{ $request->produce_collection->contract_detail->produce_item->trader->email }}</p>
                                                        <h3>To: {{ $request->produce_collection->contract_detail->contract->trader->organisation_name }}</h3>
                                                        <p>Located in: {{ $request->produce_collection->contract_detail->contract->trader->physical_address }} |
                                                        Phone: 254{{ $request->produce_collection->contract_detail->contract->trader->phone }} |
                                                        Email: {{ $request->produce_collection->contract_detail->contract->trader->email }}</p>
                                                        <h3>Item Details</h3>
                                                        {{ $request->produce_collection->quantity }} Kgs. of {{ $request->produce_collection->contract_detail->produce_item->produce->name }}
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end modal -->
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                        </tr>
                                <!--start addmodal-->
                                        <div class="modal fade" id="modal-default" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Add Driver </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="{{ route('my-delivery-requests.store')}}" method="post">
                                                        @csrf

                                                        <div class="modal-body">

                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">

                                                            <div class="form-group">
                                                                <label for="license">License:</label>
                                                                <input class="form-control" type="text" name="licence_no">
                                                                <label for="">First Name:</label>
                                                                <input class="form-control" type="text" name="firstname">
                                                                <label for="">Last Name:</label>
                                                                <input class="form-control" type="text" name="lastname">

                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Update</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--end add modal-->
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>



@endsection

@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection
