@extends('layouts.site')

@section('title')
BTCotton | Products
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Messages</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Messages</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ route('messages.create') }}" class="btn btn-primary btn-round" data-toggle="modal" data-target="#addRowModal">
        {{-- <a href="{{ route('products.create') }}" class="btn btn-primary btn-round"> --}}
            <i class="fa fa-plus"></i> New Message
        </a>
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>

        <!-- Modal -->
        <div class="modal fade" id="addRowModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header border-0">
                        <h5 class="modal-title">
                            Messages
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        {{-- <p class="small">Create a new row using this form, make sure you fill them all</p> --}}
                        @include ('layouts._messages')

                        <form action="{{ route('messages.store') }}" method="post">
                            @include ("messages._form", ['buttonText' => "New Message"])
                        </form>
                    </div>
                    <div class="modal-footer border-0">
                        {{-- <button type="button" id="addRowButton" class="btn btn-primary">Add</button> --}}
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="w-100">
            <div class="page-navs bg-white">
                <div class="nav-scroller">
                    <div class="nav nav-tabs nav-line nav-color-secondary">
                        <a class="nav-link active show" data-toggle="tab" href="#tab1">All
                            <span class="count ml-1">(7)</span>
                        </a>
                        <a class="nav-link" data-toggle="tab" href="#tab2">Starred</a>
                        <a class="nav-link" data-toggle="tab" href="#tab3">Trash</a>
                    </div>
                </div>
            </div>
            <div class="page-inner">
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex justify-content-end">
                            <div class="d-md-inline-block">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text bg-white">
                                            <i class="fa fa-search search-icon"></i>
                                        </span>
                                    </div>
                                    <input type="text" class="form-control" aria-label="Text input with dropdown button">
                                    <div class="input-group-append">
                                        <button class="btn btn-secondary dropdown-toggle" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Filter</button>
                                        <div class="dropdown-menu">
                                            <a class="dropdown-item" href="#">Action</a>
                                            <a class="dropdown-item" href="#">Another action</a>
                                            <a class="dropdown-item" href="#">Something else here</a>
                                            <div role="separator" class="dropdown-divider"></div>
                                            <a class="dropdown-item" href="#">Separated link</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            {{-- <button type="button" class="btn btn-success d-none d-sm-inline-block">New Message</button> --}}
                        </div>

                        <section class="card mt-4">
                            <div class="list-group list-group-messages list-group-flush">
                                <div class="list-group-item unread">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star1" value="1">
                                            <label for="star1">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-online">
                                                <img src="{{ asset('img/jm_denis.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">Jimmy Denis</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> How are you? </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 16 minutes ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item unread">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star2" value="1" checked>
                                            <label for="star2">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-offline">
                                                <img src="{{ asset('img/chadengle.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">Chad</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> Ok, Thanks ! </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 20 minutes ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item read">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star3" value="1">
                                            <label for="star3">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-away">
                                                <img src="{{ asset('img/talha.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">Talha</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> Follow up this reminder asap, quam error praesentium asperiores a quidem. </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 2 days ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item read">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star4" value="1">
                                            <label for="star4">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-offline">
                                                <img src="{{ asset('img/mlane.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">John Doe</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> Ready for the meeting today with client. </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 2 days ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item read">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star5" value="1">
                                            <label for="star5">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-online">
                                                <img src="{{ asset('img/arashmil.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">Arash Mil</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> Hi Guys, minus, aliquam porro repudiandae numquam. Molestias. </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 3 days ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item unread">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star6" value="1">
                                            <label for="star6">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-online">
                                                <img src="{{ asset('img/jm_denis.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">Jimmy Denis</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> How are you? </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 16 minutes ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item unread">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star7" value="1" checked>
                                            <label for="star7">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-offline">
                                                <img src="{{ asset('img/chadengle.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">Chad</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> Ok, Thanks ! </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 20 minutes ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item read">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star8" value="1">
                                            <label for="star8">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-away">
                                                <img src="{{ asset('img/talha.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">Talha</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> Follow up this reminder asap, quam error praesentium asperiores a quidem. </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 2 days ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item read">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star9" value="1">
                                            <label for="star9">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-offline">
                                                <img src="{{ asset('img/mlane.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">John Doe</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> Ready for the meeting today with client. </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 2 days ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="list-group-item read">
                                    <div class="list-group-item-figure">
                                        <span class="rating rating-sm mr-3">
                                            <input type="checkbox" id="star10" value="1">
                                            <label for="star10">
                                                <span class="fa fa-star"></span>
                                            </label>
                                        </span>
                                        <a href="conversations.html" class="user-avatar">
                                            <div class="avatar avatar-online">
                                                <img src="{{ asset('img/arashmil.jpg') }}" alt="..." class="avatar-img rounded-circle">
                                            </div>
                                        </a>
                                    </div>
                                    <div class="list-group-item-body pl-3 pl-md-4">
                                        <div class="row">
                                            <div class="col-12 col-lg-10">
                                                <h4 class="list-group-item-title">
                                                    <a href="conversations.html">Arash Mil</a>
                                                </h4>
                                                <p class="list-group-item-text text-truncate"> Hi Guys, minus, aliquam porro repudiandae numquam. Molestias. </p>
                                            </div>
                                            <div class="col-12 col-lg-2 text-lg-right">
                                                <p class="list-group-item-text"> 3 days ago </p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="list-group-item-figure">
                                        <div class="dropdown">
                                            <button class="btn-dropdown" data-toggle="dropdown">
                                                <i class="icon-options-vertical"></i>
                                            </button>
                                            <div class="dropdown-arrow"></div>
                                            <div class="dropdown-menu dropdown-menu-right">
                                                <a href="#" class="dropdown-item">Mark as read</a>
                                                <a href="#" class="dropdown-item">Mark as unread</a>
                                                <a href="#" class="dropdown-item">Toggle star</a>
                                                <a href="#" class="dropdown-item">Trash</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                        <div class="mt-1 mb-2">
                            <p class="text-muted"> Showing 1 to 10 of 1,000 entries </p>
                            <ul class="pagination justify-content-center mb-5 mb-sm-0">
                                <li class="page-item disabled">
                                    <a class="page-link" href="#" tabindex="-1">
                                        <i class="fa fa-angle-left"></i>
                                    </a>
                                </li>
                                <li class="page-item">
                                    <a class="page-link" href="#">1</a>
                                </li>
                                <li class="page-item disabled">
                                    <a class="page-link" href="#" tabindex="-1">...</a>
                                </li>
                                <li class="page-item">
                                    <a class="page-link" href="#">13</a>
                                </li>
                                <li class="page-item active">
                                    <a class="page-link" href="#">14</a>
                                </li>
                                <li class="page-item">
                                    <a class="page-link" href="#">15</a>
                                </li>
                                <li class="page-item disabled">
                                    <a class="page-link" href="#" tabindex="-1">...</a>
                                </li>
                                <li class="page-item">
                                    <a class="page-link" href="#">24</a>
                                </li>
                                <li class="page-item">
                                    <a class="page-link" href="#">
                                        <i class="fa fa-angle-right"></i>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
			<footer class="footer">
				<div class="container-fluid">
					<nav class="pull-left">
						<ul class="nav">
							<li class="nav-item">
								<a class="nav-link" href="http://www.themekita.com">
									ThemeKita
								</a>
							</li>
							<li class="nav-item">
								<a class="nav-link" href="#">
									Help
								</a>
							</li>
							<li class="nav-item">
								<a class="nav-link" href="#">
									Licenses
								</a>
							</li>
						</ul>
					</nav>
					<div class="copyright ml-auto">
						2018, made with <i class="fa fa-heart heart text-danger"></i> by <a href="http://www.themekita.com">ThemeKita</a>
					</div>
				</div>
			</footer>
		</div>
    </div>
@endsection

@section('scripts')
    <script>
        $('#editRowModal').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget) // Button that triggered the modal
            var product_id = button.data('id')
            console.log(product_id)
            // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
            // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
            var modal = $(this)
            modal.find('.modal-title').text('Update Product')
            // modal.find('.modal-body #updateForm').attr('action', "")
        })
    </script>
@endsection
