<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />
        <meta name="csrf-token" content="{{ csrf_token() }}">
        <meta name="base_url" content="{{ URL::to('/') }}">

        <title>@yield('title')</title>

        <link rel="icon" href="{{ asset('img/icon.ico') }}" type="image/x-icon"/>

        <!-- Fonts and icons -->
        <script src="{{ asset('js/plugin/webfont/webfont.min.js') }}"></script>
        <script>
            WebFont.load({
                google: {"families":["Lato:300,400,700,900"]},
                custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['{{ asset('css/fonts.min.css') }}']},
                active: function() {
                    sessionStorage.fonts = true;
                }
            });
        </script>

        <!-- CSS Files -->
        


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.2/css/all.min.css"/>
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.7.2/animate.min.css">
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css">
        <link rel="stylesheet" href="https://cdn.datatables.net/fixedcolumns/3.3.0/css/fixedColumns.dataTables.min.css">
        <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.css">
        <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}">
        <link rel="stylesheet" href="{{ asset('css/calendar.css') }}">
        <link rel="stylesheet" href="{{ asset('css/atlantis.css') }}">

        <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
       
        
        <!-- CSS Just for demo purpose, don't include it in your project -->
        {{-- <link rel="stylesheet" href="{{ asset('css/demo.css') }}"> --}}
    </head>

    <body>
                <style>
.wrapper1{
  background: #fff;
  max-width: 100%;
  width: 100%;
  border-radius: 16px;
  box-shadow: 0 0 128px 0 rgba(0,0,0,0.1),
              0 32px 64px -48px rgba(0,0,0,0.5);
}


.form1{
  padding: 25px 30px;
}
.form1 header{
  font-size: 25px;
  font-weight: 600;
  padding-bottom: 10px;
  border-bottom: 1px solid #e6e6e6;
}
.form1 form{
  margin: 20px 0;
}
.form1 form .error-text{
  color: #721c24;
  padding: 8px 10px;
  text-align: center;
  border-radius: 5px;
  background: #f8d7da;
  border: 1px solid #f5c6cb;
  margin-bottom: 10px;
  display: none;
}
.form1 form .name-details{
  display: flex;
}
.form1 .name-details .field:first-child{
  margin-right: 10px;
}
.form1 .name-details .field:last-child{
  margin-left: 10px;
}
.form1 form .field{
  display: flex;
  margin-bottom: 10px;
  flex-direction: column;
  position: relative;
}
.form1 form .field label{
  margin-bottom: 2px;
}
.form1 form .input input{
  height: 40px;
  width: 100%;
  font-size: 16px;
  padding: 0 10px;
  border-radius: 5px;
  border: 1px solid #ccc;
}
.form1 form .field input{
  outline: none;
}
.form1 form .image input{
  font-size: 17px;
}
.form1 form .button input{
  height: 45px;
  border: none;
  color: #fff;
  font-size: 17px;
  background: #333;
  border-radius: 5px;
  cursor: pointer;
  margin-top: 13px;
}
.form1 form .field i{
  position: absolute;
  right: 15px;
  top: 70%;
  color: #ccc;
  cursor: pointer;
  transform: translateY(-50%);
}
.form1 form .field i.active::before{
  color: #333;
  content: "\f070";
}
.form1 .link{
  text-align: center;
  margin: 10px 0;
  font-size: 17px;
}
.form1 .link a{
  color: #333;
}
.form1 .link a:hover{
  text-decoration: underline;
}



.wrapper1 img{
  object-fit: cover;
  border-radius: 50%;
}


.users .search button.active{
  background: #333;
  color: #fff;
}
.search button.active i::before{
  content: '\f00d';
}
.users-list{
  max-height: 350px;
  overflow-y: auto;
}
:is(.users-list, .chat-box)::-webkit-scrollbar{
  width: 0px;
}
.users-list a{
  padding-bottom: 10px;
  margin-bottom: 15px;
  padding-right: 15px;
  border-bottom-color: #f1f1f1;
}
.users-list a:last-child{
  margin-bottom: 0px;
  border-bottom: none;
}
.users-list a img{
  height: 40px;
  width: 40px;
}
.users-list a .details p{
  color: #67676a;
}
.users-list a .status-dot{
  font-size: 12px;
  color: #468669;
  padding-left: 10px;
}
.users-list a .status-dot.offline{
  color: #ccc;
}
.chat-area1{
    width:100%;
}
/* Chat Area CSS Start */
.chat-area1 header{
  display: flex;
  align-items: center;
  padding: 18px 30px;
}
.chat-area1 header .back-icon{
  color: #333;
  font-size: 18px;
}
.chat-area1 header img{
  height: 45px;
  width: 45px;
  margin: 0 15px;
}
.chat-area1 header .details span{
  font-size: 17px;
  font-weight: 500;
}
.chat-box{
  position: relative;
  min-height: 200px;
  max-height: 350px;
  overflow-y: auto;
  padding: 10px 30px 20px 30px;
  background: #f7f7f7;
  box-shadow: inset 0 32px 32px -32px rgb(0 0 0 / 5%),
              inset 0 -32px 32px -32px rgb(0 0 0 / 5%);
}
.chat-box .text{
  position: absolute;
  top: 45%;
  left: 50%;
  width: calc(100% - 50px);
  text-align: center;
  transform: translate(-50%, -50%);
}
.chat-box .chat{
  margin: 15px 0;
}
.chat-box .chat p{
  word-wrap: break-word;
  padding: 8px 16px;
  box-shadow: 0 0 32px rgb(0 0 0 / 8%),
              0rem 16px 16px -16px rgb(0 0 0 / 10%);
}
.chat-box .outgoing{
  display: flex;
}
.chat-box .outgoing .details{
  margin-left: auto;
  max-width: calc(100% - 130px);
}
.outgoing .details p{
  background: #333;
  color: #fff;
  border-radius: 18px 18px 0 18px;
}
.chat-box .incoming{
  display: flex;
  align-items: flex-end;
}
.chat-box .incoming img{
  height: 35px;
  width: 35px;
}
.chat-box .incoming .details{
  margin-right: auto;
  margin-left: 10px;
  max-width: calc(100% - 130px);
}
.incoming .details p{
  background: #fff;
  color: #333;
  border-radius: 18px 18px 18px 0;
}
.typing-area{
  padding: 18px 20px;
  display: flex;
  justify-content: space-between;
}
.typing-area input{
  height: 45px;
  width: calc(100% - 58px);
  font-size: 16px;
  padding: 0 13px;
  border: 1px solid #e6e6e6;
  outline: none;
  border-radius: 5px 0 0 5px;
}
.typing-area button{
  color: #fff;
  width: 55px;
  border: none;
  outline: none;
  background: #333;
  font-size: 19px;
  cursor: pointer;
  opacity: 0.7;
  pointer-events: none;
  border-radius: 0 5px 5px 0;
  transition: all 0.3s ease;
}
.typing-area button.active{
  opacity: 1;
  pointer-events: auto;
}

/* Responive media query */
@media screen and (max-width: 450px) {
  .form1, .users{
    padding: 20px;
  }
  .form1 header{
    text-align: center;
  }
  .form1 form .name-details{
    flex-direction: column;
  }
  .form1 .name-details .field:first-child{
    margin-right: 0px;
  }
  .form1 .name-details .field:last-child{
    margin-left: 0px;
  }

  .users header img{
    height: 45px;
    width: 45px;
  }
  .users header .logout{
    padding: 6px 10px;
    font-size: 16px;
  }
  :is(.users, .users-list) .content .details{
    margin-left: 15px;
  }

  .users-list a{
    padding-right: 10px;
  }

  .chat-area1 header{
    padding: 15px 20px;
  }
  .chat-box{
    min-height: 400px;
    width:100%;
    padding: 10px 15px 15px 20px;
  }
  .chat-box .chat p{
    font-size: 15px;
  }
  .chat-box .outogoing .details{
    max-width: 230px;
  }
  .chat-box .incoming .details{
    max-width: 265px;
  }
  .incoming .details img{
    height: 30px;
    width: 30px;
  }
  .chat-area1 form{
    padding: 20px;
  }
  .chat-area1 form input{
    height: 40px;
    width: calc(100% - 48px);
  }
  .chat-area1 form button{
    width: 45px;
  }
  .message {
    color: #444;
    padding: 18px 20px;
    line-height: 26px;
    font-size: 16px;
    border-radius: 7px;
    display: inline-block;
    position: relative;
    background:yellow;
}
.message:after {
    bottom: 100%;
    left: 7%;
    border: solid transparent;
    content: " ";
    height: 0;
    width: 0;
    position: absolute;
    pointer-events: none;
    border-bottom-color: #fff;
    border-width: 10px;
    margin-left: -10px
}
.other-message {
    background:yellow;
    text-align: right
}
#chat-box ul{
    list-style:None;
}

.other-message:after {
    border-bottom-color: #e8f1f3;
    left: 93%
}
}
.self {
  background: #efefef;
  float: right;
  clear: both;
  padding: 18px 20px;
  margin-top:2px;
  margin-bottom:3px;
  list-style: None;
  border:solid transparent;
  border-radius:3px;
}

.other {
  background: #e8f1f3;
  float: left;
  clear: both;
  padding: 18px 5px;
  margin-bottom:3px;
  
  list-style: None;
  border:solid transparent;
  border-radius:3px;
}}

</style>
    
        
            @include('_partials.back-header')

            @php
                if(Auth::user()->isAdmin()) $sidebar = '_partials.back-sidebar';
                elseif(Auth::user()->getRelatedTrader() == '')
                    $sidebar = '_partials.back-sidebar-agent';
                
                
                elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation()) $sidebar = '_partials.back-sidebar-fo';
                
                elseif(Auth::user()->getRelatedTrader()->isBulkBuyer()) $sidebar = '_partials.back-sidebar-b';
                elseif(Auth::user()->getRelatedTrader()->isBulkSeller()) $sidebar = '_partials.back-sidebar-s';
                elseif(Auth::user()->getRelatedTrader()->isAgroDealer()) $sidebar = '_partials.back-sidebar-ad';
                elseif(Auth::user()->getRelatedTrader()->isTransporter()) $sidebar = '_partials.back-sidebar-t';
                elseif(Auth::user()->getRelatedTrader()->isAgent()) $sidebar = '_partials.back-sidebar-agent';
                
            @endphp

            @include($sidebar)

            @include('_partials.back-footer')

            @include('_partials.back-drawer')
     

        @include('_partials.back-scripts')
        
    </body>
</html>
