<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <meta content='width=device-width, initial-scale=1.0, shrink-to-fit=no' name='viewport' />

        <title>@yield('title')</title>

        <link rel="icon" href="{{ asset('img/icon.ico') }}" type="image/x-icon"/>

        <!-- Fonts and icons -->
        <script src="{{ asset('js/plugin/webfont/webfont.min.js') }}"></script>
        <script>
            WebFont.load({
                google: {"families":["Lato:300,400,700,900"]},
                custom: {"families":["Flaticon", "Font Awesome 5 Solid", "Font Awesome 5 Regular", "Font Awesome 5 Brands", "simple-line-icons"], urls: ['{{ asset('css/fonts.min.css') }}']},
                active: function() {
                    sessionStorage.fonts = true;
                }
            });
        </script>

        <!-- CSS Files -->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.10/css/select2.min.css" rel="stylesheet" />
        <link rel="stylesheet" href="{{ asset('css/bootstrap.min.css') }}">
        <link rel="stylesheet" href="{{ asset('css/atlantis2.css') }}">
        <link rel="stylesheet" href="{{ asset('css/custom.css') }}">

        <!-- CSS Just for demo purpose, don't include it in your project -->
        {{-- <link rel="stylesheet" href="{{ asset('css/demo.css') }}"> --}}
    </head>

    <body>
        <div class="wrapper horizontal-layout-3">
            @include('_partials.back-header-noauth')

            {{-- @include('_partials.back-sidebar') --}}

            <div class="main-panel">
                <div class="bg-primary2 pt-4 pb-5" style="background-image: url('{{ asset('img/cotton_bg.jpg') }}'); background-position: center; background-size: cover;">
                    <div class="container text-white py-2">
                        <div class="d-flex align-items-center">
                            @yield('header')
                        </div>
                    </div>
                </div>
                <div class="container mt--5">
                    <div class="page-inner mt--3">
                        <div class="row">
                            @yield('content')
                        </div>
                    </div>
                </div>
            </div>
            <footer class="footer">
                <div class="container">
                    <nav class="pull-left">
                        <ul class="nav">
                            <li class="nav-item">
                                <a class="nav-link" href="http://www.btcotton.spin.mobisky.biz">
                                    BTCotton
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="#">
                                    Help
                                </a>
                            </li>
                           
                        </ul>
                    </nav>
                    <div class="copyright ml-auto">
                        &copy; 2021</a>
                    </div>
                </div>
            </footer>

            @include('_partials.back-drawer')
        </div>

        @include('_partials.back-scripts')

    </body>
</html>
