@csrf
<div class="form-group">
    <label for="input-name">Name</label>
    <input type="text" name="name" id="input-name" value="{{ old('name', $input->name ?? '') }}" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="Input Name">

    @if ($errors->has('name'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('name') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    @php $selectedvalue = old('category_id', $input->category_id ?? '') @endphp

    <label for="input-category_id">Category</label>
    <select id="input-category_id" name="category_id" style="width: 100%; border-color: #ebedf2;">
            <option value="">--Select--</option>
            @foreach($categories as $category)
                <option value="{{ $category->id }}" {{ $selectedvalue == $category->id ? 'selected="selected"' : '' }}>{{ sprintf('%s', $category->name) }}</option>
            @endforeach
        </select>

    @if ($errors->has('category_id'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('category_id') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    @php $selectedvalue = old('listed', $input->listed ?? '') @endphp

    <label for="input-listed">Listed?</label>
    <select name="listed" id="input-listed" class="form-control">
        <option value="">- Select -</option>
        <option value="0" {{ $selectedvalue == 0 ? 'selected="selected"' : '' }}>No</option>
        <option value="1" {{ $selectedvalue == 1 ? 'selected="selected"' : '' }}>Yes</option>
    </select>

    @if ($errors->has('listed'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('listed') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="input-description">Description</label>
    <textarea name="description" id="input-description" class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}" rows="10">{{ old('description', $input->description ?? '') }}</textarea>

    @if ($errors->has('description'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('description') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">{{ $buttonText }}</button>
</div>
