@extends('layouts.site')

@section('title')
BTCotton | Input Orders
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Input Releases</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input orders</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection
<!DOCTYPE html>
<html lang="en">
@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($inputs->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer </th>
                                        <th>Picked By</th>
                                        <th>Item(s)</th>
                                        <th>Date Released</th>

                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    @foreach($inputs as $input)
                                        <tr id="{{$input->id}}">
                                            <td><a href="{{ route('input_orders.show', $input->id)}}">{{ $input->id }}</a></td>
                                            <td>{{ $input->inputOrderItems->farmer->fullname }}</td>
                                            <td>@if($input->picked_by)
                                            <strong>Name:</strong> {{ $input->picked_by }}<br>
                                            <strong>Phone:</strong> {{ $input->phone }}<br>
                                            <strong>ID No:</strong> {{ $input->id_no }}
                                            @else
                                            Owner
                                            @endif</td>
                                            <td><strong>Item:</strong> {{ $input->inputOrderItems->input->name }}<br>
                                            <strong>Quantity:</strong> {{ $input->inputOrderItems->quantity}} {{ $input->inputOrderItems->input->input_unit->abbreviation }} </td>

                                            <td>{{ Str::limit($input->created_at,10,'.') }}</td>

                                    </tr>
                                     <!--Modal Deliver-->
                                        <div class="modal fade" id="modal-default-{{$input->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Add Transport Information | Order Ref#{{ $input->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form id="input-form" name="input-form" method="post" action="{{ route('produce-orders.store')}}">
                                                        @csrf

                                                        <div class="modal-body">

                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="transport" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    <!--/end modal deliver-->

                                    @endforeach
                                </tbody>
                                <tfoot>
                                <tr>
                                        <th>ID</th>
                                        <th>Farmer </th>
                                        <th>Picked By</th>
                                        <th>Item(s)</th>
                                        <th>Date Released</th>

                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>


        </div>
    </div>


@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection
@endsection
