@extends('layouts.site')

@section('title')
BTCotton | Input Order Items
@endsection

@section('header')
    <div class="page-header">
    <h4 class="page-title">Input Order Items | Order for {{ $order->trader->organisation_name}} #Ref: {{ $order->id}}</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Order Items</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
    <!-- <a href="#" class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#modal-default">
            <i class="fa fa-plus"></i> Add Input Order Items
        </a> -->
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <form action="{{ route('input_orders.update', $order->id) }}" method="post">
                        @method('PUT')
                        <input name="category_id" type="hidden" value="{{$order->id}}"/>

                    </form>

                    <!-- form -->
                      <!-- Modal -->
                <div id="modal-default">
                <form id="input-order-form" name="input-order-form" method="post">
                    @csrf

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                        <input type="hidden" name="id" id="input-order-item-id">
                        <input type="hidden" name="order_id" id="input-order-item-order-id" value="{{ $order->id }}">
                        <input type="hidden" name="approved" id="input-order-item-approved" value="0">
                        <input type="hidden" name="directed_to" id="input-order-item-directed-to">
                        <input type="hidden" name="total" id="input-order-item-total" value="0">
                        <div class="form-group row">
                            <div class="col-md-3">
                                <label for="trader-id">Farmer</label>
                                <select id="input-order-item-farmer-id" required name="farmer_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option  value="">- Select -</option>
                                    @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer())
                                    @foreach($agfarmers as $farmer)
                                        <option value="{{ $farmer->user_id }}" data-username="{{$farmer->user->username}}"data-credit="{{$farmer->user->wallet->credit_limit}}" data-price="{{$farmer->user->wallet->float_bal}}">{{ $farmer->user->lastname }} {{ $farmer->user->firstname }}- {{ $farmer->user->phone }}</option>
                                    @endforeach
                                    @else
                                    @foreach($farmers as $farmer)  <option value="{{ $farmer->user_id }}" data-credit="{{$farmer->user->wallet->credit_limit}}" data-price="{{$farmer->user->wallet->float_bal}}">{{ $farmer->user->lastname }} {{ $farmer->user->firstname }}- {{ $farmer->user->phone }}</option>
                                    @endforeach
                                    @endif
                                </select>
                            </div>
                             <div class="col-md-3">
                                <label for="input-order-item-input-id">Input to Purchase</label>
                                <select id="input-order-item-input-id" required name="input_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                    @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer())
                                    @foreach($inputsagro as $input)
                                        <option value="{{ $input->id }}">{{ $input->name }}</option>
                                    @endforeach
                                    @else
                                    @foreach($inputs as $input)
                                        <option value="{{ $input->id }}">{{ $input->name }}</option>
                                    @endforeach                                                                                                            @endif
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="input-order-input-item-id">Supplier</label>
                                <select required name="input_item_id" id="input-order-input-item-id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                    <option value="">- Select -</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="input-order-item-quantity">Quantity <span id="input-order-selected-quantity"></span></label>
                                <input type="number" id="input-order-item-quantity" onkeyup="sum();" required name="quantity" class="form-control" >
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="input-order-item-price">Total Price</label>
                                <input type="hidden" name="price1" id="input-order-item-price" class="form-control">
                                <input type="number" onkeyup="sum();" id="price1" required name="price" class="form-control" value="0" readonly>
                            </div>

                            <div class="col-md-3">
                                <label for="input-order-item-financing">Financing</label>
                                <input type="hidden" id="credit" class="form-control" value="0">
                                <input type="hidden" id="wallet" class="form-control" value="0">

                                <select id="input-order-item-financing" required name="financing" class="form-control select2" >
                                    <option value="">-- Select Mode --</option>

                               </select>
                            </div>
                            <div class="col-md-3">
                                <label for="input-order-item-expected-date">Expected Date</label>
                                <input type="date" onkeyup="checkPrice();" required name="expected_date" id="input-order-item-expected-date" class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label for="input-order-item-description">Description</label>
                                <textarea required name="description" onkeyup="checkPrice();" id="input-order-item-description" class="form-control"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer" id="save-btn">
                        @if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isFarmerOrganisation())
                        <button type="submit" id="input-order-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        @else
                        <input type="password" id="user1" onkeyup="checkPrice();" placeholder="confirm PIN">
                        <input type="hidden" id="user">
                        <button type="button" class="btn btn-info" onclick="checkPrice();">Confirm</button>

                        @endif
                        <button type="reset" class="btn btn-danger btn-round btn-md" data-dismiss="modal"><i class="fas fa-times"></i> Clear</button>

                    </div>
                </form>
                </div>
                    <!-- endform -->

                    @if($items->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Input</th>
                                        <th>Quantity</th>
                                        <th>Price (KSh)</th>
                                        <th>Status</th>
                                        <th>Expected On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    @foreach($items as $item)
                                        <tr id="">
                                            <td><a href="">{{ $item->id }}</a></td>
                                            <td>{{ $item->farmer->fullname }}</td>
                                            <td>{{ $item->input->name }}</td>
                                            <td>{{ $item->quantity }} {{ $item->input->input_unit->abbreviation }}</td>
                                            <td>{{ $item->price }}</td>
                                            <td>
                                            @if($item->approved == 0)
                                            <span class="btn-danger">Pending Financing</span>
                                            @elseif($item->approved == 1)
                                             <span class="btn-warning">In Process</span>
                                             @elseif($item->approved == 2)
                                             <span class="btn-success">Done</span>
                                             @elseif($item->approved == 3)
                                             <span class="btn-success">Received</span>
                                             @elseif($item->approved == 4)
                                             <span class="btn-success">Released</span>
                                             @endif
                                            </td>
                                            <td>{{ Str::limit($item->expected_date,10,'.') }}</td>
                                            <td class="text-right">
                                            @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer())
                                            <form name="approveitem" action="{{ route('bulk-seller.store')}}" method="post">
                                                    @csrf

                                                    <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <input type="hidden" name="id" value="{{ $item->id }}">
                                                    <input type="hidden" name="order_id" value="{{ $order->id }}">
                                                    <input type="hidden" name="amount" value="{{ $item->price }}">
                                                    <input type="hidden" name="financing" value="{{ $item->financing }}">
                                                    <input type="hidden" name="uid" value="{{ $item->farmer->wallet->id }}">
                                                    <input type="hidden" name="bal" value="{{ $item->farmer->wallet->balance }}">
                                                    <input type="hidden" name="approved" value="2">
                                                    @if($item->approved == 1)
                                                        <button type="submit" name="approveitem" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Complete">
                                                            <i class="fa fa-edit"></i> Complete
                                                        </button>
                                                    @endif
                                                </form>
                                                @endif

                                                <form action="{{ route('input_orders.update', $item->id)}}" method="post">
                                            @csrf
                                            @METHOD('PUT')
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                <input type="hidden" name="id" value="{{ $item->id }}">
                                                <input type="hidden" name="approved" value="1">
                                                @if($item->approved == 0)
                                                @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer())
                                                    <a href="#" class="btn btn-warning btn-sm" title="Approve" data-toggle="modal" data-target="#modal-approve-{{$item->id}}">
                                                        <i class="fas fa-check-double"></i> Approve
                                                    </a>
                                                    @else
                                                        <button type="submit" name="approveitem" class="btn btn-warning btn-sm" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="">
                                                            <i class="fas fa-check-double"></i> Approve
                                                        </button>
                                                    @endif
                                                    <a id="edit-input-item" href="{{ route('input_orders.edit', $item->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $item->id }}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>


                                                </form>

                                                @elseif($item->approved < 2)
                                                <form action="{{ route('input_orders.destroy', $item->id)}}" method="post">
                                                @csrf
                                                @method('DELETE')
                                                <input type="hidden" name="user_id" value="{{ $item->farmer->id }}">
                                                <input type="hidden" name="price" value="{{ $item->price }}">
                                                <input type="hidden" name="financing" value="{{ $item->financing }}">
                                                    <button id="delete-input" name="deleteitem" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="">
                                                        <i class="far fa-trash-alt"></i> Cancel
                                                    </button>
                                                </form>
                                                @endif
                                    </tr>
                                        <!-- Modal -->
                                    <div class="modal fade" id="modal-approve-{{$item->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title" id="modal-title">Approve order</h4>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                 <div class="modal-body">
                                                <form action="{{ route('input_orders.update', $item->id)}}" method="post">
                                                         @csrf
                                                            @METHOD('PUT')
                                                         <input type="hidden" name="id" value="{{ $item->id }}">
                                                         <input type="hidden" id="user" value="{{ $item->farmer->username }}">
                                                        <input type="hidden" name="approved" value="1">

                                                        <div class="form-group row">
                                                            <div class="col-md-12">
                                                                <label for="input-order-item-expected-date">Farmer Confirmation</label>
                                                                <input type="password" class="form-control" placeholder="confirm PIN">
                                                                <button type="submit" name='approveitem' class="btn btn-info">Confirm</button>
                                                                <button type='submit' style="display:none" name='approveitem' class='btn btn-warning btn-round btn-md'><i class="fas fa-check-double"></i> Approve</button>
                                                            </div>
                                                        </div>

                                                    <div class="modal-footer" id="save-button">


                                                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal"><i class="fa fa-remove"></i>Close</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                </div>

                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Input</th>
                                        <th>Quantity</th>
                                        <th>Price</th>
                                        <th>Status</th>
                                        <th>Expected On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>


@endsection

@section('scripts')
    <script>
        function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
            try {
                decimalCount = Math.abs(decimalCount);
                decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

                const negativeSign = amount < 0 ? "-" : "";

                let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
                let j = (i.length > 3) ? i.length % 3 : 0;

                return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
            } catch (e) {
                console.log(e)
            }
        }

        function sum() {
            var txtFirstNumberValue = document.getElementById('input-order-item-quantity').value;
            var txtSecondNumberValue = document.getElementById('input-order-item-price').value;
            if (txtFirstNumberValue == "")
                txtFirstNumberValue = 0;
            if (txtSecondNumberValue == "")
                txtSecondNumberValue = 0;

            var result = parseInt(txtFirstNumberValue) * parseInt(txtSecondNumberValue);
            if (!isNaN(result)) {
                document.getElementById('price1').value = result;
            }

        }
        function checkPrice()
        {
            var total = document.getElementById('price1').value;
            var wallet = Math.trunc(document.getElementById('wallet').value);
            var credit = Math.trunc(document.getElementById('credit').value);
            var e = document.getElementById('input-order-item-financing');
            var finance = e.selectedIndex;
            var c = "credit";
            var w = "wallet";
            if(finance == 1)
            {
                if(wallet < total){
                alert('Insufficient funds in your wallet');
                }
            }
            else
            if(finance == 2)
            {
                if(credit < total) {
                 alert('Approved credit not sufficient for this order');
                }
            }
        }

        $('#input-order-input').on('change', function(){
            var price = $(this).children('option:selected').data('price');
            $('#price').val(price);
        });

    //wallet bal
        // $('#wallet_id').on('change', function(){
        //     var float = $(this).children('option:selected').data('float');
        //     var credit = $(this).children('option:selected').data('credit');
        //     $('#input_order_financing').empty();
        //     $('#input_order_financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet [" + float + "]</option><option value='credit'>Credit[" +credit+ "]</option>");
        $('#input-order-item-farmer-id').on('change', function(){
            var price = $(this).children('option:selected').data('price');
            var credit = $(this).children('option:selected').data('credit');
            var username = $(this).children('option:selected').data('username');
            $('#input-order-item-financing').empty();
            // $('#save-btn').empty();
            $("#credit").empty();
            $("#wallet").empty();
            $("#credit").val(credit);
            $("#wallet").val(price);
            $("#user").val(username);
            if(username){
            $('#input-order-item-financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet</option><option value='credit'>Credit</option>");
            } else {
            $('#input-order-item-financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet [KSh " + formatMoney(price) + "]</option><option value='credit'>Credit[ Ksh "+formatMoney(credit) +"]</option>");
            }
            // $('#save-btn').append("'<input type='text' id='user1' placeholder='confirm username'> <input type='hidden' id='user'><button class='btn btn-info'>Confirm</button>");
        });

        //agro
        // $('#input-order-item-farmer-id').on('change', function(){
        //     var limit = $(this).children('option:selected').data('limit');
        //     var wallet = $(this).children('option:selected').data('wallet');
        //     $('#input-order-item-financing').empty();

        //     $("#credit").val(limit);
        //     $("#wallet").val(wallet);
        //     $('#input-order-item-financing').append("<option value=''>-Select Mode-</option><option value='wallet'>Wallet</option><option value='credit'>Credit</option>");
        // });
        ///show save for agro

        $('#user1').focusout(function(username,user){
            $("#user1").empty();
            var username = $("#user").val();
            var user = $("#user1").val();

            if(username == user)
            {
                var total = document.getElementById('price1').value;
                var wallet = Math.trunc(document.getElementById('wallet').value);
                var credit = Math.trunc(document.getElementById('credit').value);
                var e = document.getElementById('input-order-item-financing');
                var finance = e.selectedIndex;
                var c = "credit";
                var w = "wallet";
            if(finance == 1)
            {
                if(wallet < total){
                alert('Insufficient funds in your wallet');
                }
                else {
                    $('#save-btn').empty();
                $('#save-btn').append("<button type='submit' id='input-order-modal-save' onclick='checkPrice();' class='btn btn-primary btn-round btn-md'><i class='fa fa-check'></i> Save</button>");
                }
            } else
            if(finance == 2)
            {
                if(credit < total) {
                 alert('Approved credit not sufficient for this order');
                } else{
                    $('#save-btn').empty();
                $('#save-btn').append("<button type='submit' id='input-order-modal-save' onclick='checkPrice();' class='btn btn-primary btn-round btn-md'><i class='fa fa-check'></i> Save</button>");
                }
            }
            }
            else
            {
                $("#user1").css("background-color", "pink");
            }
        });

        //confirm after credit approval
        $('#userconfirm').focusout(function(uname,uconfirm){
            $("#userconfirm").empty();
            var uname = $("#uname").val();
            var uconfirm = $("#userconfirm").val();

            if(uname = uconfirm)
            {

            $('#save-button').empty();
            $('#save-button').append("<button type='submit' name='approveitem' class='btn btn-warning btn-round btn-md'><i class='fas fa-check-double'></i> Approve</button>");

            }
            else
            {
                $("#userconfirm").css("background-color", "pink");
            }
        });

    //input seller
        // $('#input-order-input').on('change', function() {
        //     var  id = $(this).children('option:selected').data('seller-id');
        //     var  org = $(this).children('option:selected').data('seller');
        //     $('#input-order-input-item-id').empty();
        //     $('#input-order-input-item-id').append("<option value=''>-Select Input Seller-</option><option value='" +id+ "'>" + org + "</option>");
        // });

        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });


                $('#input-order-item-farmer-id,#input-order-item-input-id, #input-order-input-item-id').select2({
                    dropdownParent: $('body')
                });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            $('#create-input-order-item').click(function(e) {
                e.preventDefault();

                $('#input-order-modal-save').val("create-input-order-item");
                $('#input-order-form').trigger("reset");
                $('#input-order-item-id').val('');
                $('#input-order-item-farmer-id').val('').trigger('change');
                $('#input-order-item-input-id').val('').trigger('change');
                $('#input-order-input-item-id').val('').trigger('change');
                $('#input-order-item-quantity').val('');
                $('#input-order-item-price').val('');
                $('#input-order-item-financing').val('').trigger('change');
                $('#input-order-item-expected-date').val('');
                $('#input-order-item-description').val('');

                $('#input-order-modal-title').html("Add Input Order Item");
                $('#input-order-crud-modal').modal('show');
            });

            $('body').on("select2:select","#input-order-item-input-id", function(e) {
                let input_item_select = $('#input-order-input-item-id');
                input_item_select
                    .empty()
                    .append(
                        $('<option />')  // Create new <option> element
                            .text("- Select -") // Set textContent
                            .prop('selected', true)
                    );

                var selected = e.params.data;

                $.ajax({
                    url: '/input_orders/get-input-items/' + selected.id,
                    dataType: 'json',
                    type: "GET",
                    success: function (data) {
                        $('#input-order-selected-quantity').text('');
                        $('#input-order-item-quantity').val('');
                        $('#input-order-item-price').val('');
                        $('#price1').val('');

                        $.each(data, function (key, datum) {
                            console.log(datum.input);
                            input_item_select
                                .append($('<option />')  // Create new <option> element
                                .val(datum.id)            // Set value as "Hello"
                                .text(datum.name+' - '+datum.trader.organisation_name+' ('+datum.input_unit.abbreviation+')') // Set textContent as "Hello"
                                .data({                  // Set multiple data-* attributes
                                    price: datum.price_per_unit,
                                    units: datum.input_unit.name,
                                    trader_id: datum.trader_id
                                })
                            );
                        })
                    },
                    error: function (data) {
                        console.log('Error:', data);
                    }
                });
            });

            $('body').on("select2:select","#input-order-input-item-id", function(e) {
                $('#input-order-item-price').val('');
                $('#input-order-selected-quantity').text('');

                let price = $(this).find(':selected').data('price');
                let units = $(this).find(':selected').data('units');
                let trader_id = $(this).find(':selected').data('trader_id');

                if(price !== undefined) $('#input-order-item-price').val(price);
                if(units !== undefined) $('#input-order-selected-quantity').text('('+units+')');
                if(trader_id !== undefined) $('#input-order-item-directed-to').val(trader_id);

                if($('#input-order-item-quantity').val()) {
                    $('#input-order-item-quantity').trigger("keyup");
                }
            });

            // store input-order (after create or edit)
            if ($("#input-order-form").length > 0) {
                console.log('Here');
                $("#input-order-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-order-form').serialize();
                        var actionType = $('#input-order-modal-save').val();
                        $('#input-order-modal-save').html('Saving...');
                        console.log(formData);
                        $.ajax({
                            data: formData,
                            url: '/input_orders/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);

                                var active = data.active == 1 ? '<i class="fa fa-check"></i>' : '';
                                var input_order_item = '<tr id="input_order_item_id_' + data.id + '"><td>' + data.farmer.fullname + '</td>';
                                    input_order_item += '<td>'+ data.input.name +'</td><td>' + data.quantity + '</td><td>' + data.price + '</td><td>' + data.approved + '</td><td class="text-right"></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     input-order
                                    // ]);

                                if (actionType == "create-input-order-item") {
                                    $('#input-order-list').prepend(input_order_item);
                                } else {
                                    $("#input_order_item_id_" + data.id).replaceWith(input_order_item);
                                }

                                $('#input-order-modal-save').html('Save');
                                $('#input-orders-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#input-order-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
@endsection
