@extends('layouts.site')

@section('title')
BTCotton | Input Units
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Input Units</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Inputs</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Units</a>
            </li>
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-input-unit" href="{{ route('input-units.create') }}" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Input Unit
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($input_units->count())
                        <div class="table-responsive">
                            <table id="input-units-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Abbreviation</th>
                                        <th>Description</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Abbreviation</th>
                                        <th>Description</th>
                                        <th class="text-right">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="input-unit-list">
                                    @foreach($input_units as $input_unit)
                                        <tr id="input_unit_id_{{ $input_unit->id }}">
                                            <td><a href="{{ $input_unit->url }}">{{ $input_unit->name }}</a></td>
                                            <td>{{ $input_unit->abbreviation }}</td>
                                            <td>{{ Str::limit($input_unit->description, '100') }}</td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-input-unit" href="{{ route('input-units.edit', $input_unit->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $input_unit->id }}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-input-unit" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $input_unit->id }}">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>

                            <!-- Modal -->
                            <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h4 class="modal-title" id="modal-title"></h4>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form id="input-unit-form" name="input-unit-form" method="post">
                                            @csrf

                                            <div class="modal-body">
                                                <input type="hidden" name="id" id="input-unit-id">
                                                <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                                                <div class="form-group">
                                                    <label for="input-unit-name">Name</label>
                                                    <input type="text" name="name" id="input-unit-name" value="" class="form-control" placeholder="Name" autofocus>
                                                </div>
                                                <div class="form-group">
                                                    <label for="input-unit-abbreviation">Abbreviation</label>
                                                    <input type="text" name="abbreviation" id="input-unit-abbreviation" value="" class="form-control" placeholder="Abbreviation">
                                                </div>
                                                <div class="form-group">
                                                    <label for="input-unit-description">Description</label>
                                                    <textarea name="description" id="input-unit-description" class="form-control"></textarea>
                                                </div>

                                            </div>
                                            <div class="modal-footer">
                                                <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-unit-form" name="input-unit-form" method="post">
                    <div class="modal-body">
                        <input type="hidden" name="id" id="input-unit-id">
                        <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                        <div class="form-group">
                            <label for="input-unit-name">Name</label>
                            <input type="text" name="name" id="input-unit-name" value="" class="form-control" placeholder="Name" autofocus>
                        </div>
                        <div class="form-group">
                            <label for="input-unit-description">Description</label>
                            <textarea name="description" id="input-unit-description" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#crud-modal').on('shown.bs.modal', function() {
                $('#input-unit-name').trigger('focus');
            });

            $('#input-units-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            $('#create-input-unit').click(function(e) {
                e.preventDefault();

                $('#modal-save').val("create-input-unit");
                $('#input-unit-form').trigger("reset");
                $('#input-unit-id').val('');
                $('#modal-title').html("Add Input Unit");
                $('#crud-modal').modal('show');
            });

            /* When click edit */
            $('body').on('click', '#edit-input-unit', function (e) {
                e.preventDefault();

                var input_unit_id = $(this).data('id');

                $.get('input-units/' + input_unit_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Input Unit");
                    $('#modal-save').val("edit-input-unit");

                    $('#input-unit-id').val(data.id);
                    $('#input-unit-name').val(data.name);
                    $('#input-unit-abbreviation').val(data.abbreviation);
                    $('#input-unit-description').val(data.description);
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            //delete
            $('body').on('click', '#delete-input-unit', function (e) {
                e.preventDefault();

                var input_unit_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: 'input-units/' + input_unit_id + '/delete-ajax',
                        success: function (data) {
                            $("#input_unit_id_" + input_unit_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            if ($("#input-unit-form").length > 0) {
                $("#input-unit-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-unit-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/input-units/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                var long_description = data.description;
                                if (long_description) var short_description = long_description.substring(0, 100);
                                console.log(data);
                                var input_unit = '<tr id="input_unit_id_' + data.id + '"><td><a href="' + data.url + '">' + data.name + '</a></td>';
                                    input_unit += '<td>' + data.abbreviation + '</td><td>' + short_description + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    input_unit += '<a id="edit-input-unit" href="' + data.url + '/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    input_unit += '<button id="delete-input-unit" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     input_unit
                                    // ]);

                                if (actionType == "create-input-unit") {
                                    $('#input-unit-list').prepend(input_unit);
                                } else {
                                    $("#input_unit_id_" + data.id).replaceWith(input_unit);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
@endsection
