@csrf
<div class="form-group">
    <label for="inputunit-name">Name</label>
    <input type="text" name="name" id="inputunit-name" value="{{ old('name', $input_unit->name ?? '') }}" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="Unit Name">

    @if ($errors->has('name'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('name') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="inputunit-abbreviation">Abbreviation</label>
    <input type="text" name="abbreviation" id="inputunit-abbreviation" value="{{ old('abbreviation', $input_unit->abbreviation ?? '') }}" class="form-control {{ $errors->has('abbreviation') ? 'is-invalid' : '' }}" placeholder="Unit Abbrevaition">

    @if ($errors->has('abbreviation'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('abbreviation') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="inputunit-description">Description</label>
    <textarea name="description" id="inputunit-description" class="form-control {{ $errors->has('description') ? 'is-invalid' : '' }}" rows="10">{{ old('description', $input_unit->description ?? '') }}</textarea>

    @if ($errors->has('description'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('description') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">{{ $buttonText }}</button>
</div>
