<div class="table-responsive">
    <table id="input-items-list" class="display table table-striped table-hover" >
        <thead>
            <tr>
                <th>Input Item</th>
                <th>Price per Unit</th>
                <th>Listed</th>
                <th class="text-right" style="width: 10%">Action</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <th>Input Item</th>
                <th>Price per Unit</th>
                <th>Listed</th>
                <th class="text-right">Action</th>
            </tr>
        </tfoot>
        <tbody id="input-item-list">
            @foreach($input_items as $input_item)
                <tr id="input_item_id_{{ $input_item->id }}">
                    <td>
                        <a href="{{ $input_item->url }}">{{ $input_item->name }}</a>
                        <br><small>Input: {{ $input_item->input->name }}</small>
                        <br><small>Unit: {{ $input_item->input_unit->name }}</small>
                    </td>
                    <td>{{ number_format($input_item->price_per_unit, 2) }}</td>
                    <td>{!! $input_item->listed == 1 ? '<i class="fa fa-check"></i>' : '';  !!}</td>
                    <td class="text-right">
                        <div class="btn-group form-actions" role="group" aria-label="Actions">
                            <a id="edit-input-item" href="{{ route('input-items.edit', $input_item->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $input_item->id }}">
                                <i class="fa fa-edit"></i> Edit
                            </a>
                            <button id="delete-input-item" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $input_item->id }}">
                                <i class="far fa-trash-alt"></i> Delete
                            </button>
                        </div>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
