@extends('layouts.site')

@section('title')
BTCotton | Input Categories
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Input Categories</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Inputs</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Categories</a>
            </li>
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a id="create-input-category" href="{{ route('input-categories.create') }}" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Input Category
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($input_categories->count())
                        <div class="table-responsive">
                            <table id="input-categories-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Parent</th>
                                        <th class="text-right">Actions</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Name</th>
                                        <th>Description</th>
                                        <th>Parent</th>
                                        <th class="text-right">Actions</th>
                                    </tr>
                                </tfoot>
                                <tbody id="input-category-list">

                                    @foreach($input_categories as $input_category)
                                        <tr id="input_category_id_{{ $input_category->id }}">
                                            <td><a href="{{ $input_category->url }}">{{ $input_category->name }}</a></td>
                                            <td>{{ Str::limit($input_category->description, '100') }}</td>
                                            <td>{{ isset($input_category->parent) ? $input_category->parent->name : '' }}</td>
                                            <td class="text-right">
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <a id="edit-input-category" href="{{ route('input-categories.edit', $input_category->id) }}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="{{ $input_category->id }}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </a>
                                                    <button id="delete-input-category" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="{{ $input_category->id }}">
                                                        <i class="far fa-trash-alt"></i> Delete
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title"></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-category-form" name="input-category-form" method="post">
                    <div class="modal-body">
                        <input type="hidden" name="id" id="input-category-id">
                        <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                        <div class="form-group">
                            <label for="input-category-name">Name</label>
                            <input type="text" name="name" id="input-category-name" value="" class="form-control" placeholder="Name" autofocus>
                        </div>
                        <div class="form-group">
                            <label for="input-category-description">Description</label>
                            <textarea name="description" id="input-category-description" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="input-category-parent_id">Parent Category</label>
                            <select id="input-category-parent_id" name="parent_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select -</option>
                                @foreach($input_categories as $category)
                                    <option value="{{ $category->id }}">{{ $category->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#input-categories-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            //onclick add
            $('#create-input-category').click(function(e) {
                e.preventDefault();

                $('#modal-save').val("create-input-category");
                $('#input-category-form').trigger("reset");
                $('#input-category-id').val('');
                $('#input-category-parent_id').val('').trigger('change');
                $('#modal-title').html("Add Input Category");
                $('#crud-modal').modal('show');
            });

            // onclick edit
            $('body').on('click', '#edit-input-category', function (e) {
                e.preventDefault();

                var input_category_id = $(this).data('id');

                $.get('input-categories/' + input_category_id +'/edit-ajax', function (data) {
                    console.log(data);
                    $('#modal-title').html("Edit Input Category");
                    $('#modal-save').val("edit-input-category");

                    $('#input-category-id').val(data.id);
                    $('#input-category-name').val(data.name);
                    $('#input-category-description').val(data.description);
                    $('#input-category-parent_id').val(data.parent_id).trigger('change');
                    $('#crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#modal-save').html('Save');
                })
            });

            //onclick delete
            $('body').on('click', '#delete-input-category', function (e) {
                e.preventDefault();

                var input_category_id = $(this).data("id");
                var confirmDelete = confirm("Are You sure want to delete?");
                if (confirmDelete) {
                    $.ajax({
                        type: "DELETE",
                        url: 'input-categories/' + input_category_id + '/delete-ajax',
                        success: function (data) {
                            $("#input_category_id_" + input_category_id).remove();
                            console.log('Success:', data);
                        },
                        error: function (data) {
                            console.log('Error:', data);
                        }
                    });
                }
            });

            //onload modal
            $('#crud-modal').on('shown.bs.modal', function() {
                $('#input-category-name').trigger('focus');

                $('#input-category-parent_id').select2({
                    dropdownParent: $('#crud-modal')
                });
            });

            //onsubmit
            if ($("#input-category-form").length > 0) {
                $("#input-category-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-category-form').serialize();
                        var actionType = $('#modal-save').val();
                        $('#modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/input-categories/store-ajax',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {

                                var long_description = data.description;
                                if (long_description) var short_description = long_description.substring(0, 100);
                                var parent = data.parent != null ? data.parent.name : '';

                                var input_category = '<tr id="input_category_id_' + data.id + '"><td><a href="'+ data.url +'">' + data.name + '</a></td>';
                                    input_category += '<td>' + short_description + '</td><td>' + parent + '</td><td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    input_category += '<a id="edit-input-category" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    input_category += '<button id="delete-input-category" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                    // $('#add-row').dataTable().fnAddData([
                                    //     $("#addName").val(),
                                    //     $("#addPosition").val(),
                                    //     $("#addOffice").val(),
                                    //     input_category
                                    // ]);

                                if (actionType == "create-input-category") {
                                    $('#input-category-list').prepend(input_category);
                                } else {
                                    $("#input_category_id_" + data.id).replaceWith(input_category);
                                }

                                $('#modal-save').html('Save');
                                $('#crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
@endsection
