@extends('layouts.site')

@section('title')
BTCotton | Farmers
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Wallet Statements</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Wallet</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>

    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($wallet_records->count())
                        <div class="table-responsive">
                            <table id="farmer-wallets-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Credit</th>
                                        <th>Debit</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Credit</th>
                                        <th>Debit</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    @foreach($wallet_records as $wallet)
                                        <tr>
                                            <td>{{ $wallet->credit }}</td>
                                            <td>{{ $wallet->debit }}</td>
                                            <td>
                                                <div class="form-button-action">
                                                   <a href="" title="" class="btn btn-primary btn-icon btn-round btn-sm" data-toggle="tooltip" data-original-title="Edit Amount">
                                                        <i class="fa fa-plus"></i>
                                                   </a>

                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>


                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $('#farmer-wallets-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });

        // $('#editRowModal').on('show.bs.modal', function (event) {
        //     var button = $(event.relatedTarget) // Button that triggered the modal
        //     var region_id = button.data('id')
        //     // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        //     // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        //     var modal = $(this)
        //     modal.find('.modal-title').text('Update Organisation Type')
        //     // modal.find('.modal-body #updateForm').attr('action', "")
        // })
    </script>
@endsection
