@extends('layouts.site')

@section('title')
BTCotton | Farmers
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Produce Units</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmers</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="" class="btn btn-primary btn-round" data-toggle="modal" data-target="#addProduceUnitModal">
            <i class="fa fa-plus"></i> Credit Wallet
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>

        <!-- Modal -->
        <div class="modal fade" id="addProduceUnitModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                           Credit Wallet
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ url('/add_wallet_money') }}" method="post">
                        <div class="modal-body">
                            @include ('layouts._messages')

                            @include ("farmers._wallet_form")

                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="submitAddButton" class="btn btn-primary btn-round">Credit Wallet</button>
                            <button type="button" class="btn btn-danger btn-round" data-dismiss="modal">Close</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $('#farmer-users-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });

        // $('#editRowModal').on('show.bs.modal', function (event) {
        //     var button = $(event.relatedTarget) // Button that triggered the modal
        //     var region_id = button.data('id')
        //     // If necessary, you could initiate an AJAX request here (and then do the updating in a callback).
        //     // Update the modal's content. We'll use jQuery here, but you could use a data binding library or other methods instead.
        //     var modal = $(this)
        //     modal.find('.modal-title').text('Update Organisation Type')
        //     // modal.find('.modal-body #updateForm').attr('action', "")
        // })
    </script>
@endsection
