@extends('layouts.site')

@section('title')
BTCotton | Farmers
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Produce Units</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmers</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="" class="btn btn-primary btn-round" data-toggle="modal" data-target="#addFarmerModal">
            <i class="fa fa-plus"></i> Add Farmer
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>

        <!-- Modal -->
        <div class="modal fade" id="addFarmerWalletModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            Credit Wallet
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ url('/add_farmer') }}" method="post">
                        <div class="modal-body">
                            @include ('layouts._messages')
                            @include ("farmers._wallet_form")

                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="submitAddButton" class="btn btn-primary btn-round">Add Farmer</button>
                            <button type="button" class="btn btn-danger btn-round" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- add a farmer modal -->
         <!-- Modal -->
         <div class="modal fade" id="addFarmerModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            Add Farmer
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ url('/add_farmer') }}" method="post">
                        <div class="modal-body">
                            @include ('layouts._messages')
                            @include ("farmers._form")

                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="submitAddButton" class="btn btn-primary btn-round">Add Farmer</button>
                            <button type="button" class="btn btn-danger btn-round" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <!-- end of add farmer modal -->
        <!---section for adding the farmer produce -->
        <div class="modal fade farmerproducemodal" id="addFarmerProduceModal" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">
                            Incoming Stock Produce
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="{{ url('/add_farmer_produce') }}" method="post">
                    {{ csrf_field() }}
                        <div class="modal-body">
                            @include ('layouts._messages')
                            @include ("farmers._farmer_produce")


                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="submitAddButton" class="btn btn-primary btn-round">Add Produce</button>
                            <button type="button" class="btn btn-danger btn-round" data-dismiss="modal">Close</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>


        <!--end modal for the farmer produce -->


    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($farmerusers->count())
                        <div class="table-responsive">
                            <table id="farmer-users-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>First Name</th>
                                        <th>Last Name</th>
                                        <th>Farmer Organisation</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                    <th>First Name</th>
                                        <th>Last Name</th>
                                        <th>Farmer Organisation</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    @foreach($farmerusers as $user)
                                        <tr>
                                            <td>
                                                <a href="{{ $user['farmerid'] }}">{{ $user['firstname'] }}</a>
                                            </td>
                                            <td>{{ $user['lastname'] }}</td>
                                            <td>{{ $user['organisation'] }}</td>
                                            <td>
                                                <div class="form-button-action">
                                                   <a href=""id="addwalletlink" class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#addFarmerWalletModal" data-original-title="Add Wallet" data-farmer-id="{{$user['farmerid']}}" data-org-id="{{$user['orgid']}}">
                                                        <i class="fa fa-plus"></i> Wallet
                                                   </a>
                                                   <a href="" id="addproducelink" class="btn btn-success btn-round btn-sm" data-toggle="modal" data-target="#addFarmerProduceModal" data-original-title="Add Produce" data-farmer-id="{{$user['farmerid']}}" data-org-id="{{$user['orgid']}}">
                                                        <i class="fa fa-plus"></i> Produce
                                                   </a>

                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>


                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $('#farmer-users-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
        /*display the farmerproducemodal with the farmerid*/
        $(document).on('click','#addproducelink',function(){
                var farmerid = $(this).data('farmer-id');
                var farmerorganisation = $(this).data('org-id');
                var fid=$("#farmerid").val(farmerid);
                var org=$("#organisationid").val(farmerorganisation);


        });

         /*display the walletmodal with the farmerid*/
         $(document).on('click','#addwalletlink',function(){
                var farmerid = $(this).data('farmer-id');
                var farmerorganisation = $(this).data('org-id');
                var fid=$("#userid").val(farmerid);
                var org=$("#orgid").val(farmerorganisation);


        });

    </script>
@endsection
