@csrf
<fieldset {{ (request()->is('*edit')) ? 'disabled' : '' }}>
                                <legend>Personal Details</legend>

                                <div class="panel panel-default">
                                    <div class="form-row">
                                        <div class="col form-group">
                                            <label for="firstname">First Name*</label>
                                            <input name="firstname" id="firstname" type="text" class="form-control {{ $errors->has('firstname') ? 'is-invalid' : '' }}" placeholder="First Name">

                                            @if ($errors->has('firstname'))
                                                <div class="invalid-feedback">
                                                    <strong>{{ $errors->first('firstname') }}</strong>
                                                </div>
                                            @endif
                                        </div> <!-- form-group end.// -->
                                        <div class="col form-group">
                                            <label for="lastname">Last Name*</label>
                                            <input name="lastname" id="lastname" type="text" class="form-control {{ $errors->has('lastname') ? 'is-invalid' : '' }}" placeholder="Last Name">

                                            @if ($errors->has('lastname'))
                                                <div class="invalid-feedback">
                                                    <strong>{{ $errors->first('lastname') }}</strong>
                                                </div>
                                            @endif
                                        </div> <!-- form-group end.// -->
                                        <div class="col form-group">
                                            <label for="email">Email*</label>
                                            <input name="email" id="email" type="email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" placeholder="Email">

                                            @if ($errors->has('email'))
                                                <div class="invalid-feedback">
                                                    <strong>{{ $errors->first('email') }}</strong>
                                                </div>
                                            @endif
                                        </div> <!-- form-group end.// -->
                                        <div class="col form-group">
                                            <label for="phone">Phone*</label>
                                            <input name="phone" id="phone" type="phone" class="form-control {{ $errors->has('phone') ? 'is-invalid' : '' }}" placeholder="Phone">

                                            @if ($errors->has('phone'))
                                                <div class="invalid-feedback">
                                                    <strong>{{ $errors->first('phone') }}</strong>
                                                </div>
                                            @endif
                                        </div> <!-- form-group end.// -->
                                    </div>      
                                </div>
                            </fieldset>
                            <hr/>    
                            <fieldset {{ (request()->is('*edit')) ? 'disabled' : '' }}>
                                <legend>Link Farmer Organisation</legend>

                                <div class="panel panel-default">
                                    <div class="form-row">
                                        <div class="col form-group">
                                            <label for="farmerorganisation">Farmer Organisation*</label>
                                            <select name="farmerorganisation" id="farmerorganisation" class="form-control" >
                                                <option>- Select -</option>
                                                @foreach ($farmerorganisations as $farmerorg)
                                                    <option value="{{ $farmerorg->id }}">{{ $farmerorg->organisation_name }}</option>
                                                @endforeach
                                            </select>
                                            @if ($errors->has('farmerorganisation'))
                                                <div class="invalid-feedback">
                                                    <strong>{{ $errors->first('farmerorganisation') }}</strong>
                                                </div>
                                            @endif
                                        </div> <!-- form-group end.// -->
                                        
                                    </div>      
                                </div>
                            </fieldset>
                            <fieldset {{ (request()->is('*edit')) ? 'disabled' : '' }}>
                                <legend>Farmer Authentication Details</legend>

                                <div class="panel panel-default">
                                    <div class="form-row">
                                        <div class="col form-group">
                                            <label for="username">Username*</label>
                                            <input name="username" id="username" type="text" class="form-control {{ $errors->has('username') ? 'is-invalid' : '' }}" placeholder="Preferred Username (e.g. jsmith)">

                                            @if ($errors->has('username'))
                                                <div class="invalid-feedback">
                                                    <strong>{{ $errors->first('username') }}</strong>
                                                </div>
                                            @endif
                                            
                                        </div> <!-- form-group end.// -->
                                        
                                    </div>      
                                </div>
                            </fieldset>
                            @if( isset($buttonText) )
                                <div class="form-group">
                                    <button type="submit" class="btn btn-primary btn-lg">{{ $buttonText }}</button>
                                </div>
                            @endif
