@extends('layouts.site')

@section('title')
BTCotton | Input Order Items
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Input Order Items | Order #{{ $order->id}}</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Order Items</a>
            </li>
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="#" class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#modal-default">
            <i class="fa fa-plus"></i> Add Input Order Items
        </a>
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <h5 class="text-right"><strong>Input Order ID:</strong> {{ $order->id }}</h5>

                    <form action="{{ route('input_orders.update', $order->id) }}" method="post">
                        @method('PUT')
                        <input name="category_id" type="hidden" value="{{$order->id}}"/>

                    </form>
                    @if($items->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Totals</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    @foreach($items as $item)
                                        <tr id="">
                                            <td><a href="">{{ $item->id }}</a></td>
                                            <td>{{ $item->inputOrderItems->fullname }}</td>
                                            <td>{{ $item->totals }}</td>
                                            <td>
                                                @if($item->approved == 0)
                                                    <span class="badge badge-danger">Pending</span>
                                                @elseif($item->approved == 1)
                                                    <span class="badge badge-warning">In Process</span>
                                                @elseif($item->approved == 2)
                                                    <span class="badge badge-success">Done</span>
                                                @endif
                                            </td>
                                            <td>{{ $item->created_at }}</td>
                                            <td class="text-right">
                                                <form action="{{ route('input_orders.update', $item->id)}}" method="post">
                                            @csrf
                                            @METHOD('PUT')
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                <input type="hidden" name="id" value="{{ $item->id }}">
                                                <input type="hidden" name="approved" value="1">
                                                    <button type="submit" name="approveitem" class="btn btn-warning btn-sm" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="">
                                                        <i class="fas fa-check-double"></i> Approve
                                                    </button>
                                                </form>
                                                <form action="{{ route('input_orders.destroy', $item->id)}}" method="post">
                                                @csrf
                                                @method('DELETE')
                                                    <button id="delete-input" name="deleteitem" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="">
                                                        <i class="far fa-trash-alt"></i> Cancel
                                                    </button>
                                                </form>
                                    </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Totals</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
                </div>
            </div>
    </div>
    <!-- Modal -->
    <div class="modal fade" id="modal-default" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title">Add Input Order Item</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-form" name="form1" method="post" action="{{ route('input_orders.store')}}">
                    @csrf

                    <div class="modal-body">
                        <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                        <input type="hidden" name="approved" value="0">
                        <input type="hidden" name="total" value="0">
                        <div class="form-group row">
                        <div class="col-md-6">
                            <label for="trader-id">Farmer</label>
                            <select onchange="farmerWallet(event)" id="input-category-id" name="farmer_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select [Name-ID] -</option>
                                @foreach($farmer as $farmer)
                                <option value="{{ $farmer->id }}">{{ $farmer->lastname }}-{{ $farmer->phone }}</option>
                                @endforeach
                            </select>
                            </div>
                            <div class="col-md-6">
                            <label for="trader-id">Input</label>
                            <select id="inputs" onchange="inputPrice(event)" name="input_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                <option value="">- Select Input -</option>
                                @foreach($input as $input)
                                <option id="{{ $input->id }}"value="{{ $input->id }}">{{ $input->name }}</option>
                                @endforeach
                            </select>
                            </div>
                            <div class="col-md-6">
                            <p id="amount">KSh</p>
                            </div>
                            <div class="col-md-6">
                            &nbsp;
                            </div>
                            <div class="col-md-6">
                            <label for="trader-id">Quantity</label>
                            <input type="text" name="quantity" class="form-control" >
                            </select>
                            </div>
                            <div class="col-md-6">
                            <label for="trader-id">Financing</label>
                            <select id="input-category-id" name="financing" class="form-control" >
                                <option value="">- Select Mode -</option>
                                <option value="wallet">Wallet</option>
                                <option value="credit">Credit</option>
                            </select>
                            </div><div class="col-md-12">
                            <label for="trader-id">Description</label>
                            <textarea name="description" class="form-control" ></textarea>

                            <label for="trader-id">Price</label>
                            <input type="text" id="price" name="price" class="form-control" >

                            <label for="trader-id">Expected Date</label>
                            <input type="date" name="expected_date" class="form-control" >
                            <input type="hidden" name="order_id" value="{{ $order->id }}">
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" name="form1" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
<script>
function inputPrice(e) {
  //var x = document.getElementById("inputs").value;
  document.getElementById("price").value = e.target.value;
}
function farmerWallet(e) {
  //var x = document.getElementById("inputs").value;
  document.getElementById("amount").value = e.target.value;
}
</script>
@endsection
