@extends('layouts.site')

@section('title')
BTCotton | Farmer plans
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Farmer Business Plans - {{ $farmer[0]->user->lastname }} </h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmer Business Plans</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ route('business-plans')}}" class="btn btn-primary btn-round">
            <i class="fa fa-plus"></i> Import Plan
        </a>
        <a href="" class="btn btn-primary btn-round" data-toggle="modal" data-target="#add">
            <i class="fa fa-plus"></i> Add New Plan
        </a>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>

        
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                <div id="vueapp">
                <!-- Modal -->
                <div class="modal fade" id="add" tabindex="-1" role="dialog" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">
                                    Add business plan
                                </h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                                <div class="modal-body">
                                    @include ('layouts._messages')
                                    
                                    <addfarmerplan-component :farmerid="{{ json_encode($id)}}"><addfarmerplan-component/>
                                    
                                </div>
                        </div>
                    </div>
                </div>
                <!-- Modal -->
                <div class="modal fade" id="add1" tabindex="-1" role="dialog" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">
                                    Use Existing Plan
                                </h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                                <div class="modal-body">
                                    @include ('layouts._messages')
                                    
                                    <importfarmerplan-component :farmerid="{{ json_encode($id)}}"><importfarmerplan-component/>
                                    
                                </div>
                        </div>
                    </div>
                </div>
                    <farmerplan-component :farmerid="{{ json_encode($id)}}"><farmerplan-component/>
                       
                </div>
            </div>
        </div>
    </div>
</div>
@endsection