@extends('layouts.site')

@section('title')
BTCotton | Farmer Credits
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Farmer Credits</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmer Credits</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <h5 class="text-right"></h5>



                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        @if(Auth()->user()->isAdmin())
                                        <th>Farmer Organization</th>
                                        <th>Contact Person</th>
                                        <th>Contact</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                        @else
                                        <th>Farmer</th>
                                        <th>Phone</th>
                                        <th>Credit Limit (KSh)</th>
                                        <th>Actions</th>
                                        @endif
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                   @if(Auth()->user()->isAdmin())
                                   @if($traders->count())
                                    @foreach($traders as $trader)
                                        <tr id="">

                                            <td><a href="{{ route('farmer-credits.show', $trader->id)}}">{{ $trader->organisation_name }}</a></td>
                                            <td>{{ $trader->user->fullname }}</td>
                                            <td>{{ $trader->user->phone }}</td>
                                            <td>
                                                @if($trader->status === 1)
                                                    <span class="badge badge-success">Active</span>
                                                @elseif($trader->status === 0)
                                                    <span class="badge badge-danger">Inactive</span>
                                                @endif
                                            </td>
                                            <td><a class="btn btn-sm btn-success" href="{{ route('farmer-credits.show', $trader->id)}}">View Farmers
                                                </a></td>
                                        </tr>
                                     @endforeach
                                     @else
                                     @include('layouts._nodata')
                                     @endif
                                    @else
                                    @if($farmers->count())
                                    @foreach($farmers as $farmer)
                                        <tr>
                                            <td><a href="{{ route('farmer-credits.show', $farmer->user->id)}}">{{ $farmer->user->fullname }}</a></td>
                                            <td>{{ $farmer->user->phone }}</td>
                                            <td>{{ $farmer->user->wallet->credit_limit }}</td>
                                            <td><a class="btn btn-sm btn-success" href="{{ route('farmer-credits.show', $farmer->user->id)}}">View Credits
                                                </a></td>
                                        </tr>
                                        @endforeach
                                        @else
                                        @include('layouts._nodata')
                                        @endif
                                    @endif


                                </tbody>
                                <tfoot>
                                    <tr>
                                    @if(Auth()->user()->isAdmin())
                                        <th>Farmer Organization</th>
                                        <th>Contact Person</th>
                                        <th>Contact</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    @else
                                    <th>Farmer</th>
                                    <th>Phone</th>
                                    <th>Credit Limit (KSh)</th>
                                    <th>Actions</th>
                                    @endif
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                </div>
                </div>
            </div>
    </div>
@endsection
@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection


