@extends('layouts.site')

@section('title')
BTCotton | Farmer Credits
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Farmer Credits - @foreach($user as $user){{$user->fullname}}@endforeach</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Credits</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmer Credits</a>
            </li>
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')


                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Requested Amount (KSh)</th>
                                        <th>Credited Amount (KSh)</th>
                                        <th>Payable Amount (KSh)</th>
                                        <th>Balance (KSh)</th>
                                        <th>Status</th>
                                        <th>Cleared</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                        </tr>
                                </thead>
                                <tbody id="input-list">
                                    @foreach($credits as $credit)
                                        <tr id="">
                                            <td><a href="">{{ $credit->id }}</a></td>
                                            <td>@if($credit->requested_amount)
                                            {{ Str::limit($credit->requested_amount,-2,'.') }}
                                            @endif</td>
                                            <td>
                                            @if($credit->credited_amount)
                                            {{ (100*$credit->payable_amount)/(100+$credit->interest)}}
                                            @endif</td>
                                            <td>@if($credit->payable_amount)
                                            {{ Str::limit($credit->payable_amount,-2,'.') }}
                                            @endif</td>
                                            <td>@if($credit->balance)
                                            {{ Str::limit($credit->balance,-2,'.') }}
                                            @endif</td>
                                            <td>
                                                @if($credit->approved == 0)
                                                    <span class="badge badge-black">Pending</span>
                                                @elseif($credit->approved == 1)
                                                    <span class="badge badge-danger">Declined</span>
                                                @elseif($credit->approved == 2)
                                                    <span class="badge badge-warning">In Process</span>
                                                @elseif($credit->approved == 3)
                                                    <span class="badge badge-success">Approved</span>
                                                @endif
                                            </td>
                                             <td>
                                             @if($credit->cleared == 2)
                                             Confirmed
                                            @elseif($credit->cleared == 1)
                                             <i class="fa fa-check"></i>
                                             @else
                                             Pending
                                             @endif</td>

                                            <td>{{ Str::limit($credit->created_at,10,'.') }}</td>
                                            <td>
                                            @if($credit->cleared == 1)
                                            <form action="{{ route('farmer-credits.store')}}" method="post">
                                            @csrf
                                            <input type="hidden" value="{{ $credit->id }}" name="credit_id">
                                            <button type="submit" onsubmit="return confirm('Confirm Pay?')" name="confirm" class="btn btn-success btn-sm" title="Confirm Payment">
                                                            <i class="fa fa-check"></i> Confirm Pay
                                                        </button>
                                            </form>
                                            @endif
                                            <button type="button" class="btn btn-info btn-sm" title="Payments" data-original-title="Payments" data-id=""data-toggle="modal" data-target="#modal-viewPay-{{$credit->id}}">
                                                            <i class="fa fa-file-o"></i> Payments
                                                        </button>

                                            </td>
                                    </tr>

                                        <!--Modal view payment-->
                                    <div class="modal fade" id="modal-viewPay-{{$credit->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog modal-lg" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">View Payment History | Request Ref#{{ $credit->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>

                                                        <div class="modal-body">
                                                        <div class="row">
                                                        @if($credit->cleared == 0)
                                                        <div class="col-sm-3">
                                                        <h5>Amount (KSh)</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>TransactionID</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>Date</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>Action</h5>
                                                        </div>
                                                        <form action="{{ route('farmer-credits.store')}}" method="post">
                                                        @csrf
                                                        <div class="col-sm-3">
                                                        <input class="form-control" type="text" name="amount" required>
                                                        <input value="{{ $credit->id }}" name="credit_id" type="hidden">
                                                        <input value="{{ $credit->balance }}" name="balance" type="hidden">
                                                        <input value="{{ $credit->credited_amount }}" name="credited_amt" type="hidden">
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <input class="form-control" name="source" required type="text" placeholder="e.g. Cash,Cheque">
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <input class="form-control" required type="date">
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <button class="form-control btn btn-primary" name="pay" type="submit"><i class="fa fa-save"></i> Save</button>
                                                        </div>
                                                        </form>
                                                        <br>
                                                        @endif
                                                        <div class="col-sm-3">
                                                        <h5>#ID</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>Amount (KSh)</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>TransactionID</h5>
                                                        </div>
                                                        <div class="col-sm-3">
                                                        <h5>Date</h5>
                                                        </div>

                                                        @foreach($credit->creditClearing as $payments)
                                                        <div class="col-sm-3">
                                                        {{ $payments->id }}
                                                        </div>
                                                        <div class="col-sm-3">
                                                        {{ $payments->amount }}
                                                        </div>
                                                        <div class="col-sm-3">
                                                        {{ $payments->source }}
                                                        </div>
                                                        <div class="col-sm-3">
                                                        {{ Str::limit($payments->created_at,10,'') }}
                                                        </div>
                                                        @endforeach
                                                        </div>
                                                        </div>
                                                        <div class="modal-footer">

                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal view payment-->
                                        @endforeach

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Requested Amount (KSh)</th>
                                        <th>Credited Amount (KSh)</th>
                                        <th>Payable Amount (KSh)</th>
                                        <th>Balance (KSh)</th>
                                        <th>Status</th>
                                        <th>Cleared</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                </div>
                </div>
            </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>

@endsection
