@extends('layouts.site')

@section('title')
BTCotton | Transport Drivers
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Drivers</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Drivers</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">

            <button class="btn btn-primary btn-round btn-sm" data-toggle="modal" data-target="#modal-default" id="show-modal">
                <i class="fa fa-plus"></i> Add Drivers
            </button>

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs.
                         <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    </div>

                @endif
                    @include ('layouts._messages')

                    @if($drivers->count())
                        <div class="table-responsive">
                            <table  id="inputs-list" class="display table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>S/No</th>
                                        <th>Full Name</th>
                                        <th>Experience</th>
                                        <th>Class</th>
                                        <th>Phone</th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>S/No</th>
                                        <th>Full Name</th>
                                        <th>Experience</th>
                                        <th>Class</th>
                                        <th>Phone</th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    @foreach($drivers as $driver)
                                        <tr id="{{ $driver->id }}">
                                            <td> {{ ++$i }}</td>
                                            <td>{{ $driver->firstname }} {{ $driver->lastname }} </td>
                                            <td>{{ $driver->experience }}</td>
                                            <td>{{ $driver->driver_class }}</td>
                                            <td>{{ $driver->phone }}</td>
                                            <td>{{ $driver->email }}</td>
                                            <td>
                                                @if($driver->status == 1)
                                                   <span class="badge badge-danger">Unavailable</span>
                                                @else
                                                   <span class="badge badge-success">Available</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <button type="button" name="view" class="btn btn-success btn-sm" title="view" data-original-title="view" data-id=""data-toggle="modal" data-target="#modal-default1-{{$driver->id}}">
                                                        <i class="fa fa-check"></i> View
                                                    </button>
                                                    <button type="button" name="edit" class="btn btn-info btn-sm" title="edit" data-original-title="edit" data-id=""data-toggle="modal" data-target="#modal-default-{{$driver->id}}">
                                                        <i class="fa fa-edit"></i> Edit
                                                    </button>
                                                    <form name="delete" action="{{ route('drivers.destroy', $driver->id)}}" method="post">
                                                    @csrf
                                                    @METHOD('DELETE')
                                                    <button type="submit" name="delete" onsubmit="return confirm('Delete Driver?')" class="btn btn-danger btn-sm" title="delete">
                                                        <i class="fa fa-trash"></i> Delete
                                                    </button>
                                                    </form>
                                                </div>

                                            </td>
                                            <!-- Modal Edit-->

                                        <div class="modal fade" id="modal-default-{{$driver->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Driver Ref#{{ $driver->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="{{ route('drivers.update', $driver->id)}}" method="post">
                                                        @csrf
                                                        @METHOD('PUT')
                                                        <div class="modal-body">

                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">

                                                            <div class="form-group">
                                                                <label for="license">License:</label>
                                                                <input class="form-control" type="text" name="licence_no" value="{{ $driver->licence_no  }}">
                                                                <label for="">First Name:</label>
                                                                <input class="form-control" type="text" name="firstname" value="{{ $driver->firstname }}">
                                                                <label for="">Last Name:</label>
                                                                <input class="form-control" type="text" name="lastname" value="{{ $driver->lastname }}">
                                                                <label for="">Driver Class:</label>
                                                                <input class="form-control" type="text" name="driver_class" value="{{ $driver->driver_class }}">
                                                                <label for="">Email Address:</label>
                                                                <input class="form-control" type="text" name="email" value="{{ $driver->email }}">
                                                                <label for="">Phone:</label>
                                                                <input class="form-control" type="text" name="phone" value="{{ $driver->phone }}">
                                                                <label for="">Years of Experience:</label>
                                                                <input class="form-control" type="number" name="experience" value="{{ $driver->experience }}">
                                                                <label for="">Unavailable?:</label>
                                                                <input type="hidden" value="0" name="status">
                                                                @if ($driver->status === 1)
                                                                    <input type="checkbox" name="status" checked="" value="1">
                                                                @else
                                                                    <input type="checkbox" value ="1" name="status"}} >
                                                                @endif
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" onsubmit="return confirm('Edit Driver?')"id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Update</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                                        </tr>
                                
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!--start addmodal-->
    <div class="modal fade" id="modal-default" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modal-title">Add Driver</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
                        <form action="{{ route('drivers.store')}}" method="post">
                            @csrf

                            <div class="modal-body">

                                <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">

                                <div class="form-group">
                                    <label for="license">License:</label>
                                    <input class="form-control" type="text" name="licence_no" required>
                                    <label for="">First Name:</label>
                                    <input class="form-control" type="text" name="firstname" required>
                                    <label for="" required>Last Name:</label>
                                    <input class="form-control" type="text" name="lastname" required>
                                    <label for="">Driver Class:</label>
                                    <input class="form-control" type="text" name="driver_class" required>
                                    <label for="">Email Address:</label>
                                    <input class="form-control" type="text" name="email" required>
                                    <label for="">Phone:</label>
                                    <input class="form-control" type="text" name="phone" required>
                                    <label for="">Years of Experience:</label>
                                    <input class="form-control" type="number" name="experience" required>
                                    <label for="">Available?:</label>
                                    <input type="checkbox" name="status" value="1">

                                    <input type="hidden"name="trader_id" value="{{ $trader->id }}">
                                </div>

                            </div>
                            <div class="modal-footer">
                                <button type="submit" onsubmit="return confirm('Add Driver?')" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!--end add modal-->
@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection

@endsection


