@extends('layouts.site')

@section('title')
BTCotton | Input Deliveries
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Input Deliveries</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Invoices</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($deliveries->count())
                        <div class="table-responsive">
                        <table id="inputs-list" class="display table table-striped table-hover" >

<thead>
    <tr>
        <th>Order Ref No#</th>
        @if(Auth::user()->isAdmin())
        <th>From</th>
        <th>To</th>
        @endif
        <th>Picked/Delivered By</th>
        <th>Mode of Delivery</th>
        <th>Date Transported</th>
        <th>Expected Date</th>
        <th>Status</th>

        <th>Actions</th>

        </tr>
</thead>
<tbody id="input-list">
    @foreach($deliveries as $delivery)
        <tr id="{{$delivery->id}}">
            <td><a href="#" title="View Acknowledgement" data-original-title="View Acknowledgement" data-id=""data-toggle="modal" data-target="#viewItems-{{$delivery->id}}">
             {{ $delivery->order_id }}
            </a></td>
            @if(Auth::user()->isAdmin())
            <td>{{ $delivery->inputOrderItemsRelease->organisation_name }}</td>
            <td>{{ $delivery->inputOrders->trader->organisation_name }}</td>
            @endif
            <td>{{ $delivery->recipient }}</td>
            <td>{{ $delivery->means }}</td>
            <td>{{ Str::limit($delivery->created_at,10,'.') }}</td>
            <td>{{ Str::limit($delivery->date,10,'.') }}</td>
            <td>
            @if($delivery->status == 2)
                <span class="badge badge-black">Received</span>
                @elseif($delivery->status == 1)
                <span class="badge badge-warning">Released</span>
                @else
                <span class="badge badge-danger">Pending</span>
            @endif
            </td>

            <td>
            @if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isFarmerOrganisation())
            @if($delivery->status < 2)
            <button type="button" class="btn btn-info btn-sm" title="Confirm" data-original-title="Confirm" data-id=""data-toggle="modal" data-target="#confirm-{{$delivery->id}}">
                                                            <i class="fas fa-truck-moving"></i> Confirm Receipt
                                                        </button>
            @elseif($delivery->status === 2)
            <button type="button" class="btn btn-success btn-sm" title="View Acknowledgement" data-original-title="View Acknowledgement" data-id=""data-toggle="modal" data-target="#viewAck-{{$delivery->id}}">
              <i class="fas fa-check"></i> View Acknowledgement
            </button>
            @endif
            @elseif($delivery->status === 2)
            <button type="button" class="btn btn-success btn-sm" title="View Acknowledgement" data-original-title="View Acknowledgement" data-id=""data-toggle="modal" data-target="#viewAck-{{$delivery->id}}">
              <i class="fas fa-check"></i> View Acknowledgement
            </button>

            @endif
            </td>
    </tr>
                                    <!--Modal Confirm receipt-->
                                    <div class="modal fade" id="confirm-{{$delivery->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Confirm Receipt | Order Ref#{{ $delivery->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="confirm-receipt" method="post" action="{{ route('deliveries.store')}}">
                                                        @csrf

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                                                            <input type="hidden" name="trader_id" value="{{ $delivery->inputOrders->trader->id }}">
                                                            <div class="form-group">
                                                                <label for="trader-id">State of input at arrival</label>
                                                                <textarea class="form-control"name="state_of_arrival"></textarea>
                                                                <label for="trader-id">Other Comments</label>
                                                                <textarea name="comment" class="form-control"></textarea>

                                                                <input type="hidden" name="input_order_items_release_id" value="{{ $delivery->id }}">
                                                                <input type="hidden" name="order_id" value="{{ $delivery->order_id }}">
                                                                <input type="hidden" name="status" value="2">
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" name="confirm-receipt" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal confirm receipt-->
                                    <!--Modal view Confirm -->
                                    <div class="modal fade" id="viewAck-{{$delivery->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Delivery Acknowledgement | Delivery Ref#{{ $delivery->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="confirm-receipt" method="post" action="{{ route('deliveries.store')}}">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <h3>State of Arrival</h3>
                                                            @if($delivery->release->count())
                                                            {{ $delivery->release[0]->state_of_arrival}}
                                                            @endif
                                                            <h3>Other comments</h3>
                                                            @if($delivery->release->count())
                                                            {{ $delivery->release[0]->comment}}
                                                            @endif
                                                            <h3>Delivered on</h3>
                                                            @if($delivery->release->count())
                                                            {{ Str::limit($delivery->release[0]->created_at,10,'.')}}
                                                            @endif
                                                        </div>

                                                        <div class="modal-footer">

                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal view confirm-->
                                        <!--Modal view items -->
                                    <div class="modal fade" id="viewItems-{{$delivery->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title">Input Order Items  | Delivery Ref#{{ $delivery->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form name="confirm-receipt" method="post" action="{{ route('deliveries.store')}}">
                                                        @csrf
                                                        <div class="modal-body">

                                                            @foreach($delivery->inputOrders->orderItems as $item)
                                                            {{ $item->input->name }} | {{ $item->quantity }} {{ $item->input->input_unit->abbreviation }}<br>
                                                            @endforeach
                                                        </div>

                                                        <div class="modal-footer">

                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                        <!--/end modal view items-->
    @endforeach
</tbody>
<tfoot>
    <tr>
        <th>Order Ref No#</th>
        @if(Auth::user()->isAdmin())
        <th>From</th>
        <th>To</th>
        @endif
        <th>Picked/Delivered By</th>
        <th>Mode of Delivery</th>
        <th>Date Transported</th>
        <th>Expected Date</th>
        <th>Status</th>
        @if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isFarmerOrganisation())
        <th>Actions</th>
        @endif
    </tr>
</tfoot>
</table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>


        </div>
    </div>


@endsection
@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection
