@extends('layouts.site')

@section('title')
    BTCotton | Dashboard
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Dashboard</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Inputs</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        {{-- <a id="create-input" href="#" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-plus"></i> Add Button
        </a> --}}
    </div>
@endsection

@section('content')
    @if(Auth::user()->isAdmin())
        @include ('_partials.dashboard-admin')
    @elseif(Auth::user()->getRelatedTrader() == '')
        @include ('_partials.dashboard-agent')
    @elseif(Auth::user()->getRelatedTrader()->isFarmerOrganisation())
        @include ('_partials.dashboard-farmer-organisation')
    @elseif(Auth::user()->getRelatedTrader()->isBulkBuyer())
        @include ('_partials.dashboard-bulk-buyer')
    @elseif(Auth::user()->getRelatedTrader()->isBulkSeller())
        @include ('_partials.dashboard-bulk-seller')
    @elseif(Auth::user()->getRelatedTrader()->isAgroDealer())
        @include ('_partials.dashboard-agrodealer')
    @elseif(Auth::user()->getRelatedTrader()->isTransporter())
        @include ('_partials.dashboard-transporter')
        
    @endif
@endsection

@section('scripts')
    @if(Auth::user()->isAdmin())
        {!! $dashboard['trader_chart']->script() !!}
        {!! $dashboard['trader_type_chart']->script() !!}
    @endif
    @if(isset($dashboard['producechart']))
        {!! $dashboard['producechart']->script() !!}
    @endif
@endsection
