@extends('layouts.site')

@section('title')
BTCotton | Financing Requests
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Credit Requests</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Credit Requests</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <h5 class="text-right"></h5>


                    @if($creditwithorders->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>Input Order #ID</th>
                                        @if(Auth()->user()->isAdmin())
                                            <th>Farmer Organization</th>
                                        @endif
                                        <th>Total Requests</th>
                                        <td>Status</td>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Input Order #ID</th>
                                        @if(Auth()->user()->isAdmin())
                                            <th>Farmer Organization</th>
                                        @endif
                                        <th>Total Requests</th>
                                        <td>Status</td>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                                <tbody id="input-list">
                                    @foreach($creditwithorders as $creditwithorder)
                                    <tr id="input_order_{{ $creditwithorder->id }}">
                                            <td><a href="{{ route('credit_requests.show', $creditwithorder->id)}}"></a>{{ $creditwithorder->id }}</td>
                                            @if(Auth()->user()->isAdmin())
                                                <td>{{ $creditwithorder->trader->organisation_name }}</td>
                                            @endif
                                            <td>{{ $creditwithorder->orderItems->where('financing', 'credit')->count('quantity') }}</td>
                                            <td>
                                                @if($creditwithorder->approved == 0)
                                                    <span class="badge badge-black">Pending</span>
                                                @elseif($creditwithorder->approved == 1)
                                                    <span class="badge badge-warning">In Process</span>
                                                @elseif($creditwithorder->approved == 2)
                                                    <span class="badge badge-success">Completed</span>
                                                @endif
                                            </td>
                                            <td>{{ $creditwithorder->created_at }}</td>
                                            <td><a class="btn btn-sm btn-success" href="{{ route('credit_requests.show', $creditwithorder->id)}}">View Requests
                                                </a></td>

                                    </tr>
                                    @endforeach
                                </tbody>

                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
                </div>
            </div>
    </div>
@endsection
@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection


