@extends('layouts.site')

@section('title')
BTCotton | Financing Requests
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Credit Requests for Order #{{ $order->id }}</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="{{ route('credit_requests.index') }}">Credit Requests</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <span>Order #{{ $order->id }}</span>
            </li>
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <div class="text-right">
                        <a href="{{ route('export', $order->id) }}?id={{$order->id}}" class="btn btn-info btn-border btn-round btn-sm mr-2">
                            <i class="fa fa-pencil"></i>
                            Export Excel
                        </a>
                        <a href="#" class="btn btn-info btn-border btn-round btn-sm mr-2">
                            <i class="fa fa-print"></i>
                            Print PDF
                        </a>
                    </div>
                    <hr>

                    @if($credit->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Requested Amount</th>
                                        <th>Credit Limit</th>
                                        <th>Order Details</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    @foreach($credit as $credit)
                                        <tr id="">
                                            <td><a href="">{{ $credit->id }}</a></td>
                                            <td>{{ $credit->user->fullname }}</td>
                                            <td>{{ number_format($credit->requested_amount, 2) }}</td>
                                            <td>{{ number_format($credit->user->wallet->credit_limit, 2) }}</td>
                                            <td>
                                                <b>Input:</b> {{ $credit->inputOrderItems->input->name }}
                                                <br><b>Quantity:</b>{{ $credit->inputOrderItems->quantity}} {{ $credit->inputOrderItems->input->input_unit->abbreviation }}
                                            </td>
                                            <td>
                                                @if($credit->approved == 0)
                                                    <span class="badge badge-black">Pending</span>
                                                @elseif($credit->approved == 1)
                                                    <span class="badge badge-danger">Declined</span>
                                                @elseif($credit->approved == 2)
                                                    <span class="badge badge-warning">In Process</span>
                                                @elseif($credit->approved == 3)
                                                    <span class="badge badge-success">Approved</span>
                                                @endif
                                            </td>
                                            <td>{{ Str::limit($credit->created_at,10,'.') }}</td>
                                            <td>
                                            @if(Auth::user()->isAdmin())
                                            <form action="{{ route('credit_requests.store')}}" method="post">

                                            @csrf

                                            <input type="hidden" name="uid" value="{{ $credit->user->wallet->id }}">
                                            <input type="hidden" name="id" value="{{ $credit->id }}">
                                            <input type="hidden" name="credited" value="{{ $credit->requested_amount }}">
                                            <input type="hidden" name="io_id" value="{{ $credit->input_order_item_id }}">
                                            @if($credit->approved == 0)
                                            <div class="btn-group form-group">

                                            <button type="submit" name="process" class="btn btn-sm btn-success">Process</button>


                                            <button type="submit" name="decline" class="btn btn-sm btn-danger">Decline</button>
                                            </div>

                                            @elseif($credit->approved == 1)
                                            <div class="btn-group form-group">

                                            <button type="submit" name="accept" class="btn btn-sm btn-success">Accept</button>
                                            </div>

                                            @elseif($credit->approved == 2)
                                            <div class="btn-group form-group">

                                            <button type="button" name="approve" class="btn btn-sm btn-warning" title="Approve" data-original-title="Approve" data-id=""data-toggle="modal" data-target="#modal-approve-{{$credit->id}}"><i class="fas fa-check-double"></i> Approve</button>


                                            <button type="submit" name="decline" class="btn btn-sm btn-danger">Decline</button>
                                            </div>
                                            @endif
                                            </form>
                                            @endif
                                            </td>

                                    </tr>
                                    <!--Modal Confirm receipt-->
                                    <div class="modal fade" id="modal-approve-{{$credit->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title">Approve Credit Request | Ref#{{ $credit->id }} </h4>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <form name="approve" method="post" action="{{ route('credit_requests.store')}}">
                                                    @csrf

                                                    <input type="hidden" name="uid" value="{{ $credit->user->wallet->id }}">
                                                    <input type="hidden" name="id" value="{{ $credit->id }}">
                                                    <input type="hidden" name="io_id" value="{{ $credit->inputOrderItems->id }}">
                                                    <input type="hidden"name="requested_amt" value="{{ Str::limit($credit->requested_amount,-5,'') }}">
                                                    <div class="modal-body">
                                                        @php
                                                            $user_credits = App\Credits::where('user_id', $credit->user_id)->get();
                                                            $balance = 0;

                                                            foreach($user_credits as $user_credit) {
                                                                $balance += $user_credit->balance;
                                                            }
                                                        @endphp

                                                        <div class="alert alert-success shadow-sm">
                                                            <dl class="row">
                                                                <dt class="col-md-5">Requested by:</dt>
                                                                <dd class="col-md-7">{{ $credit->user->fullname }}</dd>
                                                                <dt class="col-md-5">Farmer Organisation:</dt>
                                                                <dd class="col-md-7">{{ $credit->user->trader->organisation_name }}</dd>
                                                                <dt class="col-md-5">Credit Limit</dt>
                                                                <dd class="col-md-7">KSh {{ number_format($credit->user->wallet->credit_limit, 2) }}</dd>
                                                                <dt class="col-md-5">Requested Amount</dt>
                                                                <dd class="col-md-7">KSh {{ number_format($credit->requested_amount, 2) }}</dd>
                                                                <dt class="col-md-5">Pending Loans Total</dt>
                                                                <dd class="col-md-7">KSh {{ $balance }}</dd>
                                                            </dl>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="credited_amt" class="mb-0">Credited Amount</label>
                                                            <small class="d-block mb-2 text-italics">Change if approved amount is less than the requested amount</small>
                                                            <input class="form-control" type="text" id="credited_amt" name="credited_amt" value="{{ Str::limit($credit->requested_amount,-5,'') }}">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="interest">Interest (%)</label>
                                                            <input class="form-control" type="number" id="interest" onkeyup="payable();" name="interest">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="period">Period (Months)</label>
                                                            <input class="form-control" onkeyup="payable();" type="number" id="period" name="period">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="payable_amount">Payable Amount</label>
                                                            <input class="form-control" id="payable_amount" name="payable_amount" >
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" name="approve" class="btn btn-warning btn-round btn-md"><i class="fas fa-check-double"></i> Approve</button>
                                                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/end modal confirm receipt-->
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                    <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Requested Amount</th>
                                        <th>Credit Limit</th>
                                        <th>Order Details</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
                </div>
            </div>
    </div>
@endsection

@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
    function payable()
    {
        var credit = document.getElementById('credited_amt').value;
            var interest = document.getElementById('interest').value;
            if (credit == "")
                credit = 0;
            if (interest == "")
                interest = 0;

            var result = parseInt(credit)+(parseInt(credit) * parseInt(interest))/100;
            if (!isNaN(result)) {
                document.getElementById('payable_amount').value = result;
            }
    }
</script>

@endsection
