@extends('layouts.site')

@section('title')
BTCotton | Counties - {{ $county->name }}
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">County - {{ $county->name }}</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Counties</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        {{-- <a href="{{ route('counties.create') }}" class="btn btn-primary btn-round" data-toggle="modal" data-target="#addRowModal"> --}}
        <a href="{{ route('counties.edit', $county->id) }}" class="btn btn-primary btn-round btn-sm">
            <i class="fa fa-edit"></i> Edit County
        </a>
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <p><b>County ID:</b> {{ $county->id }}</p>
                    <p><b>Name:</b> {{ $county->name }}</p>
                    <p><b>Code:</b> <br>{{ $county->code }}</p>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')

@endsection
