@csrf
<div class="form-group">
    <label for="county-name">Name</label>
    <input type="text" name="name" id="county-name" value="{{ old('name', $county->name ?? '') }}" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="County Name">

    @if ($errors->has('name'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('name') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="county-code">Code</label>
    <input type="text" id="county-code" class="form-control {{ $errors->has('code') ? 'is-invalid' : '' }}" value="{{ old('code', $county->code ?? '') }}">

    @if ($errors->has('code'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('code') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="county-latitude">Latitude</label>
    <input type="text" id="county-latitude" class="form-control {{ $errors->has('latitude') ? 'is-invalid' : '' }}" value="{{ old('latitude', $county->latitude ?? '') }}">

    @if ($errors->has('latitude'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('latitude') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <label for="county-longitude">Longitude</label>
    <input type="text" id="county-longitude" class="form-control {{ $errors->has('longitude') ? 'is-invalid' : '' }}" value="{{ old('longitude', $county->longitude ?? '') }}">

    @if ($errors->has('longitude'))
        <div class="invalid-feedback">
            <strong>{{ $errors->first('longitude') }}</strong>
        </div>
    @endif
</div>
<div class="form-group">
    <button type="submit" class="btn btn-primary btn-lg">{{ $buttonText }}</button>
</div>
