@extends('layouts.site')

@section('title')
BTCotton | Collection
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">Collection</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}

        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Collection</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        @if (isset($trader))
            <a id="create-aggregation" href="" class="btn btn-primary btn-round btn-sm">
                <i class="fa fa-plus"></i> Collect
            </a>
        @endif

        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                @if ($errors->any())
                        <div class="alert alert-danger alert-dismissible" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                           <strong>Error! </strong>There were some errors with inputs.
                         <ul>
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    </div>

                @endif
                    @include ('layouts._messages')

                    @if($produce_aggregations->count())
                        <div class="table-responsive">
                            <table id="aggregations-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                        <th>Trader</th>
                                        <th>Produce</th>
                                        <th>Quantity</th>
                                        <th>Details</th>
                                        <th class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Trader</th >
                                        <th>Produce</th>
                                        <th>Quantity</th>
                                        <th>Status</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody id="aggregation-list">
                                    @foreach($produce_aggregations as $produce_aggregation)
                                        <tr id="aggregation_id_{{ $produce_aggregation->id }}">
                                            <td>{{ $produce_aggregation->id }}</td>
                                            <td>
                                                {{ $produce_aggregation->produce_id }}</td>
                                            <td>{{ $produce_aggregation->balance }}</td>
                                            <td>
                                                @if($produce_aggregation->approved == 1)
                                                    <span class="badge badge-success">Approved</span>
                                                @else
                                                    <span class="badge badge-danger">Not Approved</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    @if (!$produce_aggregation->approved)

                                                    <button type="button" name="collect" class="btn btn-success btn-sm" title="Collect" data-original-title="Collect" data-id=""data-toggle="modal" data-target="#modal-default-{{$produce_aggregation->id}}">
                                                        <i class="fa fa-check"></i> Collect
                                                    </button>
                                                    @endif

                                                </div>

                                            </td>
                                            <!-- Modal -->

                                        <div class="modal fade" id="modal-default-{{$produce_aggregation->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Collection Ref#{{ $produce_aggregation->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form action="{{ route('collections.store')}}" name="form-collect" method="post">
                                                        @csrf

                                                        <div class="modal-body">
                                                            <input type="hidden" name="produce_item_id" value="{{ $cid[0] }}">
                                                            <input type="hidden" name="quantity" value="{{ $produce_aggregation->quantity }}">
                                                            <input type="hidden" name="status" value="1">
                                                            <input type="hidden" name="produce_order_item_id" value="{{ $pid }}">
                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">

                                                            <div class="form-group">

                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                                        </tr>

                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>



@endsection

@section('scripts')

@endsection
