@extends('layouts.site')

@section('title')
BTCotton | Farmers
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">@if($selectedtrader->count()) {{ $selectedtrader[0] }} @else {{ 'All' }} @endif Farmers</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmers</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
            <div id="vueapp">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($allfarmers->count())
                        <!-- end advisories -->
                        <!-- button -->
                        <div class="text-right text-white mb-3 border-bottom pb-3">
                            <a class="btn btn-success btn-sm btn-round btn-border" data-toggle="collapse" data-target="#filter-panel">
                                <i class="fa fa-filter"></i> Filter
                            </a>
                            <!-- <a class="btn btn-info btn-round" data-toggle="collapse" data-target="#advisory-panel">
                                <i class="fa fa-comments"></i> Sent Text Question
                            </a> -->

                        </div>
                        
                        <!-- content -->
                        <!-- filter -->
                        <div id="filter-panel" class="collapse filter-panel mb-2">
                            <div class="panel panel-default bg-light p-3">
                                <div class="panel-body">
                                    <form class="form" role="form">
                                        <div class="row">
                                            <div class="form-group col-xs-3 col-md-3">
                                                <label class="control-label" for="filter-name">FO</label>
                                                <select name="trader" id="filter-trader" class="form-control">
                                                    <option value="">All</option>
                                                    @foreach($fos as $fo)
                                                        <option value="{{ $fo->id }}">{{ $fo->organisation_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                                <button type="submit" id="filter-submit" class="btn btn-primary btn-round btn-sm">
                                                    <i class="fas fa-filter"></i> Filter
                                                </button>
                                                <a href="" class="btn btn-primary btn-round btn-border btn-sm">Clear</a>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <!-- group messages -->
                        <div id="advisory-panel" class="collapse advisory-panel mb-2">
                            <div class="panel panel-default bg-light p-3">
                            <h3>Recipients: {{ $allfarmers->count() }}</h3>
                                <div class="panel-body row">
                                    <div class="col-md-6">
                                    <!-- sms -->
                                        <textquestion-component :farmer="{{ json_encode($allfarmers)}}"/>
                                    <!-- /end sms -->
                                    </div>
                                    <div class="col-md-6">
                                    <!-- ivr -->
                                        <audioquestionivr-component :farmer="{{ json_encode($allfarmers)}}"/>
                                    <!-- /end ivr -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end send advisories -->

                        <div class="table-responsive">
                      <table id="farmer-users-list" class="display table table-striped table-hover" >
                                <thead>
                                    <tr>
                                    <th># </th>
                                    <th>Farmer </th>
                                        <th>Organization</th>
                                        <th>Coach</th>
                                        <th>Status</th>
                                        <th colspan="2" class="text-center" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                    <th># </th>
                                        <th>Farmer </th>
                                        <th>Organization</th>
                                        <th>Coach</th>
                                          <th>Status</th>
                                        <th colspan="2" class="text-center">Action</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    @foreach($expert_messages as $expert_message)
                                        <tr>
                                            <td>
                                                <a href="#">{{ $expert_message->id }}</a>
                                            </td>
                                            <td>
                                            @if($expert_message->videoCoach) 
                                            {{  $expert_message->videoCoach->middlename }}
                                            @endif
                                            
                                            </td>
                                            <td>
                                            @if($expert_message->videoOrganization) 
                                            {{  $expert_message->videoOrganization->organisation_name }}
                                            @endif
                                           </td>
                                            <td>                                          
                                            @if($expert_message->videoCoach) 
                                            {{  $expert_message->videoCoach->lastname }}
                                            @endif
                                            </td>
                                            <td>@if(($expert_message->status=1)) 
                                            (Seen)
                                             @else 
                                             ({{ $expert_message->status=0 }} Not Seen) @endif
                                      
                                            </td>
                                            <td>
                                          <div class="media">
                                            <div class="media-body">
                                      <iframe width="260" height="115" src="/storage/cover_images/{{$expert_message->video_url}}" frameborder="0" allowfullscreen>
                                      </iframe>
                                            </div>
                                        </div>
                                            
                                    </td>
                                     <td>
                                   
                                                    <div class="form-button-action" role="group" aria-label="Actions">
                                                    <div class="btn-group btn-group-sm"><a href="#" class="btn btn-sm btn-success" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Actions</a>
                                                        <button type="button" class="btn btn-success btn-sm dropdown-toggle dropdown-toggle-split" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                            <span class="sr-only">Toggle Dropdown</span>
                                                        </button>
                                                        <ul class="dropdown-menu dropdown-menu-left">
                                                       
                                                  

                                       
                                                    <a class="dropdown-item" href="{{ route('videoquestion.confirm', $expert_message->id) }}"  data-target="#smstext-{{ $expert_message->id }}"><i class="fa fa-plus"></i>Confirm</a>
                          
                                                    <a class="dropdown-item" href="#" data-toggle="modal" data-target="#smstext-{{$expert_message->id}}"><i class="fa fa-plus"></i> Send Text Message</a>

                                                    <a class="dropdown-item" href="{{ route('videoquestion.delete', $expert_message->id) }}"  data-target="#smstext-{{ $expert_message->id }}"><i class="fa fa-plus"></i>Delete</a>
                                                  
                                                    </div>
                                                </div>



                                        </td>                <!-- Modal -->
                                        <div class="modal fade" id="smstext-{{$expert_message->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">
                                                            Send Text Message -{{$expert_message->id}}
                                                        </h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                        <div class="modal-body">
                                                           
                                                        <smsvideoquestion-component :videoquestiondata="{{ json_encode($expert_message)}}"><smsvideoquestion-component/>
                                                            
                                                        </div>
                                                </div>
                                            </div>
                                        </div>

                                            <!-- Modal -->
                                            <div class="modal fade" id="ivr-{{$expert_message->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title">
                                                                Send Voice Message -{{$expert_message->id}}
                                                            </h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                            <div class="modal-body">
                                                                
                                                            <addivr-component :farmer="{{ json_encode($expert_message->user)}}"><addivr-component/>
                                                                
                                                            </div>
                                                    </div>
                                                </div>
                                            </div>

                             <!--sms modal-->

                            
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>


                            </div>  
                    @else
                        @include('layouts._nodata')
                    @endif
                                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(document).ready(function () {
            $('#farmer-users-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
        /*display the farmerproducemodal with the farmerid*/
        $(document).on('click','#addproducelink',function(){
                var farmerid = $(this).data('farmer-id');
                var farmerorganisation = $(this).data('org-id');
                var fid=$("#farmerid").val(farmerid);
                var org=$("#organisationid").val(farmerorganisation);


        });

         /*display the walletmodal with the farmerid*/
         $(document).on('click','#addwalletlink',function(){
                var farmerid = $(this).data('farmer-id');
                var farmerorganisation = $(this).data('org-id');
                var fid=$("#userid").val(farmerid);
                var org=$("#orgid").val(farmerorganisation);


        });

    </script>
@endsection
