@extends('layouts.site')

@section('title')
BTCotton | Input Orders
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title">@if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer())
        Agrodealer
                                                    @else
                                                    Input Seller @endif | Input Orders</h4>
        {{-- <h5 class="op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#" class="btn btn-icon btn-sm btn-round btn-light">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
            <li class="nav-item">
                <a href="#">Input orders</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>

    </div>
    <div class="ml-md-auto py-2 py-md-0">
         <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    @if($inputs->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization</th>
                                        <th>Total Items</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                @foreach($inputs as $input)
                                        <tr id="{{$input->id}}">
                                            <td><a href="{{ route('bulk-seller.show', $input->id)}}">{{ $input->id }}</a></td>
                                            <td>{{ $input->trader->organisation_name }}</td>
                                            <td>{{ $input->orderItems->count('quantity') }}</td>
                                            <td>

                                             @php
                                             $uid = Auth::user()->id;
                                             $trader = App\Trader::where('user_id',$uid)->pluck('id');
                                             $pending = App\inputOrderItems::where('order_id',$input->id)->where('directed_to',$trader[0])->where('approved',1)->get();
                                             $completed = App\inputOrderItems::where('order_id',$input->id)->where('directed_to',$trader[0])->where('approved',2)->get();
                                             $delivered = App\inputOrderItems::where('order_id',$input->id)->where('directed_to',$trader[0])->where('approved',3)->get();
                                             $received = App\inputOrderItems::where('order_id',$input->id)->where('directed_to',$trader[0])->where('approved',4)->get();

                                                if(count($pending))
                                                 {
                                                     echo '<span class="badge badge-danger">' .count($pending) ." - Pending".'</span><br>';
                                                 }
                                                 if(count($completed))
                                                 {
                                                    echo '<span class="badge badge-success">' .count($completed) ." - Completed".'</span><br>';
                                                 }
                                                 if(count($delivered))
                                                 {
                                                     echo '<span class="badge badge-success">' .count($delivered) ." - Delivered".'</span><br>';
                                                 }
                                                 if(count($received))
                                                 {
                                                     echo '<span class="badge badge-success">' .count($received) ." - Received".'</span><br>';
                                                 }

                                             @endphp
                                            </td>
                                            <td>{{ Str::limit($input->created_at,10,'.') }}</td>
                                            <td class="text-right">
                                            <form action="{{ route('bulk-seller.update', $input->id)}}" method="post">
                                                @csrf
                                                @METHOD('PUT')
                                                <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                <input type="hidden" name="id" value="{{ $input->id }}">

                                                <input type="hidden" name="approved" value="2">
                                                <a href="{{ route('bulk-seller.show', $input->id)}}">
                                                <button type="button" class="btn btn-success btn-sm" data-toggle="tooltip" title="View Items" data-original-title="View Items" data-id="">
                                                        <i class="fa fa-edit"></i> View Items
                                                    </button>
                                                    </a>
                                                    @if((count($pending) == 0) && (count($completed)>0))
                                                    @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isBulkSeller())

                                                <button type="button" name="deliver" class="btn btn-primary btn-sm" title="Deliver" data-original-title="Deliver" data-id=""data-toggle="modal" data-target="#modal-default-{{$input->id}}">
                                                        <i class="fa fa-edit"></i> Deliver
                                                    </button>
                                                    @endif
                                                    @endif
                                                    @if(count($completed))
                                                    @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer())
                                                    <button type="submit" name="approveorder" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Approve" data-original-title="Approve" data-id="">
                                                        <i class="fa fa-edit"></i> Complete
                                                    </button>
                                                    <button type="button" name="deliver" class="btn btn-primary btn-sm" title="Deliver" data-original-title="Deliver" data-id=""data-toggle="modal" data-target="#modal-default-{{$input->id}}">
                                                        <i class="fa fa-edit"></i> Deliver
                                                    </button>
                                                    @endif
                                                    @endif
                                                </form>
                                                @if($input->approved == 0)
                                                <form action="{{ route('bulk-seller.destroy', $input->id)}}" method="post">
                                                @csrf
                                                @method('DELETE')
                                                    <button id="delete-input" name="deleteorder" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="">
                                                        <i class="far fa-trash-alt"></i> Cancel
                                                    </button>
                                                </form>
                                                @endif
                                    <!-- Modal -->
                                    <div class="modal fade" id="modal-default-{{$input->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h4 class="modal-title" id="modal-title">Add Delivery Information | Item Ref#{{ $input->id }} </h4>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <form id="input-form" name="input-form" method="post" action="{{ route('bulk-seller.store')}}">
                                                        @csrf

                                                        <div class="modal-body">
                                                            <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                                                            <input type="hidden" name="approved" value="1">
                                                            <input type="hidden" name="id" value="{{ $input->id }}">
                                                            <input type="hidden" name="trader_id" value="{{ $input->trader_id }}">
                                                            <input type="hidden" name="total" value="{{ $input->price }}">
                                                            <div class="form-group align-left">
                                                                <label for="trader-id">Delivered/Picked By</label>
                                                                <input type="text" name="recipient" class="form-control">
                                                                <label for="trader-id">Means of Delivery</label>
                                                                <input type="text" name="means" class="form-control">
                                                                <label for="trader-id">Date Picked/Delivered</label>
                                                                <input type="date" name="date" class="form-control">
                                                                <input type="hidden" name="order_id" value="{{$input->id}}">
                                                            </div>

                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" id="modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                                                            <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </tr>

                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer Organization</th>
                                        <th>Total Items</th>
                                        <th>Status</th>
                                        <th>Created On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>


        </div>
    </div>


@endsection
@section('scripts')
<script>
$(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });
        });
</script>
@endsection
