@extends('layouts.site')

@section('title')
BTCotton | Input Order Items
@endsection

@section('header')
    <div class="page-header">
    <h4 class="page-title">Input Order Items | Order for {{ $order->trader->organisation_name}}  Ref# {{ $order->id}}</h4>
        {{-- <h5 class="text-white op-7 mb-2">Lorem ipsum dolor sit amet, consectetur adipiscing elit</h5> --}}
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Orders</a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Input Order Items</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @include ('layouts._messages')

                    <h5 class="text-right"><strong>Input Order ID:</strong> {{ $order->id }}</h5>

                    <form action="{{ route('bulk-seller.update', $order->id) }}" method="post">
                        @method('PUT')
                        <input name="category_id" type="hidden" value="{{$order->id}}"/>

                    </form>
                    @if($items->count())
                        <div class="table-responsive">
                            <table id="inputs-list" class="display table table-striped table-hover" >

                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Input</th>
                                        <th>Quantity</th>
                                        <th>Price (KSh)</th>
                                        <th>Status</th>
                                        <th>Expected On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </thead>
                                <tbody id="input-list">
                                    @foreach($items as $item)
                                        <tr id="">
                                            <td><a href="">{{ $item->id }}</a></td>
                                            <td>{{ $item->farmer->fullname }}</td>
                                            <td>{{ $item->input->name }}</td>
                                            <td>{{ $item->quantity }} {{ $item->input->input_unit->abbreviation }}</td>
                                            <td>{{ $item->price }}</td>
                                            <td>
                                            @if($item->approved == 0)
                                            <span class="badge badge-danger">Pending Financing</span>
                                            @elseif($item->approved == 1)
                                             <span class="badge badge-warning">In Process</span>
                                             @elseif($item->approved == 2)
                                             <span class="badge badge-success">Done</span>
                                             @elseif($item->approved == 3)
                                             <span class="badge badge-success">Delivered</span>
                                             @elseif($item->approved == 4)
                                             <span class="badge badge-success">Received</span>
                                             @endif
                                            </td>
                                            <td>{{ Str::limit($item->expected_date,10,'.') }}</td>
                                            <td class="text-right">
                                                <form name="approveitem" action="{{ route('bulk-seller.store')}}" method="post">
                                                    @csrf

                                                    <div class="btn-group form-actions" role="group" aria-label="Actions">
                                                    <input type="hidden" name="id" value="{{ $item->id }}">
                                                    <input type="hidden" name="order_id" value="{{ $order->id }}">
                                                    <input type="hidden" name="amount" value="{{ $item->price }}">
                                                    <input type="hidden" name="financing" value="{{ $item->financing }}">
                                                    <input type="hidden" name="uid" value="{{ $item->farmer->wallet->id }}">
                                                    <input type="hidden" name="bal" value="{{ $item->farmer->wallet->balance }}">
                                                    <input type="hidden" name="approved" value="2">
                                                    @if($item->approved == 1)
                                                        <button type="submit" name="approveitem" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Complete">
                                                            <i class="fa fa-edit"></i> Complete
                                                        </button>
                                                    @endif
                                                </form>

                                                @if($item->approved == 1)
                                                @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isBulkSeller())
                                                    <button id="forward-input-order-item" type="button" class="btn btn-warning btn-sm" data-toggle="tooltip" title="Forward" data-original-title="Forward" data-id="{{ $item->id }}">
                                                        <i class="fas fa-forward"></i> Forward
                                                    </button>
                                                @endif
                                                @endif
                                            </td>
                                        </tr>

                                    </tr>

                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>ID</th>
                                        <th>Farmer</th>
                                        <th>Input</th>
                                        <th>Quantity</th>
                                        <th>Price (KSh)</th>
                                        <th>Status</th>
                                        <th>Expected On</th>
                                        <th class="text-right" style="width: 10%">Action</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    @else
                        @include('layouts._nodata')
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="input-order-item-crud-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="input-order-item-modal-title" id="input-order-item-modal-title">Add Network</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form id="input-order-item-form" name="input-order-item-form" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                    <input type="hidden" name="id" id="input-order-item-id">
                    <input type="hidden" name="forwarded_by" id="input-order-item-forwarded-by" value="{{ $trader->id }}">

                    <div class="modal-body">
                        <div class="form-group">
                            <label for="input-order-item-forwarded-to">Forward to...</label>
                            <select id="input-order-item-forwarded-to" name="forwarded_to" style="width: 100%; border-color: #ebedf2;" class="form-control">
                                <option value="">- Select -</option>
                                @foreach($trader->networks as $trader_network)
                                    <option value="{{ $trader_network->agrodealer->id }}">{{ sprintf('%s - %s', $trader_network->agrodealer->organisation_name, ucwords($trader_network->type)) }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="input-order-item-modal-save" class="btn btn-primary btn-round btn-md"><i class="fa fa-check"></i> Save</button>
                        <button type="button" class="btn btn-dark btn-round btn-md" data-dismiss="modal">Close</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        function inputPrice(e) {
            //var x = document.getElementById("inputs").value;
            document.getElementById("price").value = e.target.value;
        }
        function farmerWallet(e) {
            //var x = document.getElementById("inputs").value;
            document.getElementById("amount").value = e.target.value;
        }

        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('#inputs-list').DataTable({
                "order": [[ 0, "desc" ]]
            });

            // on click forward-input-order-item
            $('body').on('click', '#forward-input-order-item', function (e) {
                e.preventDefault();

                var input_order_item_id = $(this).data('id');

                $.get('/input_orders/forward-input-item/' + input_order_item_id, function (data) {
                    $('#input-order-item-modal-title').html("Forward Order");
                    $('#input-order-item-modal-save').val("forward-input-order-item");

                    $('#input-order-item-id').val(data.id);

                    $('#input-order-item-crud-modal').modal('show');
                })
                .fail(function (jqXHR, textStatus, errorThrown) {
                    // console.warn(xhr.responseText)
                    console.log(JSON.stringify(jqXHR));
                    console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                    $('#input-order-item-modal-save').html('Save');
                })
            });

            if ($("#input-order-item-form").length > 0) {
                $("#input-order-item-form").validate({
                    submitHandler: function(form) {
                        let formData = $('#input-order-item-form').serialize();
                        var actionType = $('#input-order-item-modal-save').val();
                        $('#input-order-item-modal-save').html('Saving...');

                        $.ajax({
                            data: formData,
                            url: '/input_orders/forward-input-item',
                            type: "POST",
                            dataType: 'json',
                            success: function (data) {
                                console.log(data);
                                let listed = data.listed == 1 ? '<i class="fa fa-check">' : '';

                                let network = '<tr id="trader_network_id_' + data.id + '"><td>' + data.agrodealer.organisation_name;
                                    network += '<small><br><b>Type: </b><span class="text-capitalize">'+ data.type +'</span>';
                                    network += (data.type == 'regional') ? '<br><b>Region:</b> '+ data.region.name : '';
                                    network += (data.type == 'last-mile') ? '<br><b>County:</b> '+ data.county.name : '';
                                    network += '</small></td>';
                                    network += '<td class="text-right"><div class="btn-group form-actions" role="group" aria-label="Actions">';
                                    network += '<a id="edit-network" href="'+ data.url +'/edit" class="btn btn-primary btn-sm" data-toggle="tooltip" title="Edit" data-original-title="Edit" data-id="'+ data.id +'"><i class="fa fa-edit"></i> Edit</a>';
                                    network += '<button id="delete-network" type="submit" class="btn btn-danger btn-sm" data-toggle="tooltip" title="Delete" data-original-title="Delete" data-id="'+ data.id +'"><i class="far fa-trash-alt"></i> Delete</button></div></td></tr>';

                                if (actionType == "create-trader-network") {
                                    $('#trader-network-list').prepend(network);
                                } else {
                                    $("#network_id_" + data.id).replaceWith(network);
                                }

                                $('#input-order-item-modal-save').html('Save');
                                $('#trader-networks-crud-modal').modal('hide');
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                // console.warn(xhr.responseText)
                                console.log(JSON.stringify(jqXHR));
                                console.log("AJAX error: " + textStatus + ' : ' + errorThrown);
                                $('#input-order-item-modal-save').html('Save');
                            }
                        });
                    }
                });
            }
        });
    </script>
@endsection
