@extends('layouts.site')

@section('title')
BTCotton | Farmers
@endsection

@section('header')
    <div class="page-header">
    <link rel='stylesheet' href='https://fonts.googleapis.com/css?family=Lato'>
        <ul class="breadcrumbs">
            <li class="nav-home">
                <a href="#">
                    <i class="flaticon-home"></i>
                </a>
            </li>
            <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Farmers</a>
            </li>
            {{-- <li class="separator">
                <i class="flaticon-right-arrow"></i>
            </li>
            <li class="nav-item">
                <a href="#">Buttons</a>
            </li> --}}
        </ul>
    </div>
    <div class="ml-md-auto py-2 py-md-0">
        <a href="{{ URL::previous() }}" class="btn btn-white btn-round btn-sm ml-1">
            <i class="fas fa-caret-left"></i> Back
        </a>
    </div>
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.3.1/dist/leaflet.css"
    integrity="sha512-Rksm5RenBEKSKFjgI3a41vrjkw4EVPlJ3+OiI65vTjIdo9brlAacEuKOiQ5OFh7cOI1bkDwLqdLw3Zg0cRJAAQ=="
    crossorigin=""/>
    <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.4.1/dist/MarkerCluster.css" />
    <link rel="stylesheet" href="https://unpkg.com/leaflet.markercluster@1.4.1/dist/MarkerCluster.Default.css" />

    <style>
        #mapid { min-height: 700px; }
    </style>
@endsection

@section('content')
    <div class="row row-card-no-pd mt--2">
        <div class="col-md-12">
            <div class="card">
            <div id="vueapp">
                <div class="card-body">
                    @include ('layouts._messages')

                    <div class="text-right mb-3 border-bottom pb-3">
                        <a id="traders-export" class="btn btn-primary btn-border btn-round btn-sm">
                            <!--<i class="far fa-file-excel"></i> Export Excel -->
                        </a>
                                            <a class="btn btn-sm btn-info btn-border pull-right" href="{{ route('btcottonpdf') }}">Print Report</a>

                        <button type="submit" onclick="printDiv('printableArea')" class="btn btn-primary glow mb-1 mb-sm-0 mr-0 mr-sm-1">
                                                        Print</button>
                        <!-- <a class="btn btn-success btn-border btn-round btn-sm" data-toggle="collapse" data-target="#filter-panel">
                            <i class="fas fa-filter"></i> Filter
                        </a> -->
                    </div>
                        
                        <!-- content -->
                        <!-- filter -->
                        <div id="filter-panel" class="collapse filter-panel mb-2">
                            <div class="panel panel-default bg-light p-3">
                                <div class="panel-body">
                                    <form class="form" role="form">
                                        <div class="row">
                                            <div class="form-group col-xs-3 col-md-3">
                                                <label class="control-label" for="filter-name">FO</label>
                                      
                                            </div>
                                            
                                        </div>
                                        <div class="row">
                                            <div class="col">
                                               
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
  <div id="printableArea">
                        <div class="card">
                          
                            <div class="card-body" id="mapid"></div>
                        </div>  </div>

                        
          
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    
<!-- Make sure you put this AFTER Leaflet's CSS -->
<script src="https://unpkg.com/leaflet@1.3.1/dist/leaflet.js"
                            integrity="sha512-/Nsx9X4HebavoBvEBuyp3I7od5tA0UzAxs+j83KgC8PU0kgB4XiK4Lfe4y4cgBtaRJQEIFCW+oC506aPT2L1zw=="
                            crossorigin=""></script>
                        <script src="https://unpkg.com/leaflet.markercluster@1.4.1/dist/leaflet.markercluster.js"></script>

                        <script>
                            var map = L.map('mapid').setView([{{ config('leaflet.map_center_latitude') }}, {{ config('leaflet.map_center_longitude') }}], {{ config('leaflet.zoom_level') }});

                            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                                attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
                            }).addTo(map);
                            var markers = L.markerClusterGroup();
                            var url="https://btcotton.spin.mobisky.biz/api/map_counties";
                            axios.get('{{ url('/api/map_counties') }}')
                            .then(function (response) {
                                console.log(response)
                                var marker = L.geoJSON(response.data, {
                                    pointToLayer: function(geoJsonPoint, latlng) {
                                        
                                console.log(latlng);
                                        return L.marker(latlng).bindPopup(function (layer) {
                                            return layer.feature.properties.map_popup_content;
                                        });
                                    }
                                });
                                console.log(marker);
                                markers.addLayer(marker);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                            

                            map.addLayer(markers);

                            @can('create', new App\County)
                            var theMarker;

                            map.on('click', function(e) {
                                let latitude = e.latlng.lat.toString().substring(0, 15);
                                let longitude = e.latlng.lng.toString().substring(0, 15);

                                if (theMarker != undefined) {
                                    map.removeLayer(theMarker);
                                };

                                var popupContent = "Your location : " + latitude + ", " + longitude + ".";
                               
                                theMarker = L.marker([latitude, longitude]).addTo(map);
                                theMarker.bindPopup(popupContent)
                                .openPopup();
                            });
                            @endcan
                        </script>
                        
                                 	<script>
function printDiv(divName) {
     var printContents = document.getElementById(divName).innerHTML;
     var originalContents = document.body.innerHTML;

     document.body.innerHTML = printContents;

     window.print();

     document.body.innerHTML = originalContents;
}
</script>
                        
                        
                        
@endsection
