@extends('layouts.noauth')

@section('title')
    BTCotton | Login
@endsection

@section('header')
    <div class="page-header">
        <h4 class="page-title" style="color:white;font-weight:bold">Login</h4>
        <h5 class="op-7 mb-2"><text style="color:white">Don't have an account? </text><a href="{{ url('register_user') }}" style="color:white;font-weight:bold">Sign up</a></h5>
  
        <h5 class="op-7 mb-2"><text style="color:white">Don't have an account? </text><a href="{{ url('register_user_no_organization') }}" style="color:white;font-weight:bold">Sign up without an Organization</a></h5>
    </div>
@endsection

@section('content')
<div class="col-md-7">
    <div class="card">
        <div class="card-body">
            @include ('layouts._messages')

            <form action="{{ route('login') }}" method="post">
                @csrf
                <div class="login-form">
                    <div class="form-group">
                        <label for="login-username">Username</label>
                        <input name="username" id="login-username" type="text" class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" placeholder="Username">

                        @if ($errors->has('username'))
                            <div class="invalid-feedback">
                                <strong>{{ $errors->first('username') }}</strong>
                            </div>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="login-password">Password</label>
                        <input id="login-password" name="password" type="password" class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" placeholder="Password">

                        @if ($errors->has('password'))
                            <div class="invalid-feedback">
                                <strong>{{ $errors->first('password') }}</strong>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="form-group">
                    <input type="submit" class="btn btn-warning btnLogin" value="Login" style="color:white;font-weight:bold">
                    <a href="#" class="btn btn-link">Forgotten your password?</a>
                </div>
            </form>
        </div>
    </div>
</div>
{{-- <div class="col-md-5">
    <div class="card">
        <div class="card-body">

        </div>
    </div>
</div> --}}
@endsection

@section('scripts')
    <script>
        $(function () {
            $("#login-seller").click(function () {
                if ($(this).is(":checked")) {
                    $(".seller-fields").show();
                } else {
                    $(".seller-fields").hide();
                }
            });
        });
    </script>
@endsection
