@csrf
<style type="text/css">
    #buyer_type_category{
        display: none;
    }
</style>

<div class="row trader-form">
    <div class="col-md-6">
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-organisation-name">Organisation Name*</label>
                <input type="text" name="organisation_name" id="trader-organisation-name" value="" class="form-control" placeholder="Organisation Name" autofocus>
                @if ($errors->has('organisation_name'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('organisation_name') }}</strong>
                    </div>
                @endif
            </div>
        </div>
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-email">Email*</label>
                <input name="email" id="trader-email" type="email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" placeholder="Email" value="{{ old('email', $trader->email ?? '') }}">

                @if ($errors->has('email'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('email') }}</strong>
                    </div>
                @endif
            </div>

            <div class="col form-group">
                <label for="trader-phone">Phone Number</label>
                <input name="phone" id="trader-phone" type="text" class="form-control {{ $errors->has('phone') ? 'is-invalid' : '' }}" placeholder="Phone Number" value="{{ old('phone', $trader->phone ?? '') }}">

                @if ($errors->has('phone'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('phone') }}</strong>
                    </div>
                @endif
            </div>
        </div>
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-postal_address">Postal Address</label>
                <textarea name="postal_address" id="trader-postal_address" class="form-control {{ $errors->has('postal_address') ? 'is-invalid' : '' }}" placeholder="Postal Address">{{ old('postal_address', $trader->postal_address ?? '') }}</textarea>
                @if ($errors->has('postal_address'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('postal_address') }}</strong>
                    </div>
                @endif
            </div>
        </div>
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-region">Region*</label><br>
                <select name="region_id" id="trader-region-id" class="form-control">
                    <option value="">- Select -</option>
                        @foreach ($regions as $region)
                    <option value="{{ $region->id }}">{{ $region->name }}</option>
                        @endforeach
                </select>
                @if ($errors->has('region_id'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('region_id') }}</strong>
                    </div>
                @endif
            </div>
        </div>
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-county">County*</label><br>
                <select name="county_id" id="trader-county-id" class="form-control">
                                            <option value="">- Select -</option>
                                            @foreach ($counties as $county)
                                                <option value="{{ $county->id }}">{{ $county->name }}</option>
                                            @endforeach
                </select>
                @if ($errors->has('county_id'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('county_id') }}</strong>
                    </div>
                @endif
            </div>
            <div class="col form-group">
                <label for="trader-ward">Ward*</label><br>
                <input type="text" name="ward_id" id="trader-ward" class="form-control {{ $errors->has('ward') ? 'is-invalid' : '' }}" placeholder="Ward" value="{{ old('ward', $trader->ward ?? '') }}">
                @if ($errors->has('ward'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('ward') }}</strong>
                    </div>
                @endif
            </div>
        </div>
        {{-- <div class="form-row">
            <div class="col form-group">
                <label for="trader-preferred-regions">Preferred Regions*</label><br>
                <select name="preferred_regions" id="trader-preferred-regions" class="form-control" multiple>
                    <option>- Select -</option>
                    @foreach ($regions as $key => $value)
                        <option value="{{ $key }}" {{ old('preferred_regions', $trader->preferred_regions ?? '') == $key ? 'selected="selected"' : '' }}>{{ $value->name }}</option>
                    @endforeach
                </select>
                @if ($errors->has('preferred_regions'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('preferred_regions') }}</strong>
                    </div>
                @endif
            </div>
        </div> --}}
    </div>
    <div class="col-md-6">
        <div class="form-row">
            <div class="col form-group">
                <label for="trader-type-id">Organisation Type*</label>            
                <select id="trader-type-id" name="type_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>
                                            @foreach($trader_types as $trader_type)
                                                <option value="{{ $trader_type->id }}">{{ $trader_type->name }}</option>
                                            @endforeach
                </select>
                @if ($errors->has('type_id'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('type_id') }}</strong>
                    </div>
                @endif
            </div>
        </div>

        <div class="form-row" id="buyer_type_category">
            <div class="col form-group">
                <label for="buyer-type-id">Buyer Type*</label>            
                <select id="buyer-type-id" name="buyer_type" class="form-control" style="width: 100%; border-color: #ebedf2;">
                                            <option value="">- Select -</option>                                            
                                                <option value="1">Ginner</option>
                                                <option value="2">Spinner</option>
                                         
                </select>
                @if ($errors->has('buyer-type-id'))
                    <div class="invalid-feedback">
                        <strong>{{ $errors->first('buyer-type-id') }}</strong>
                    </div>
                @endif
            </div>
        </div>
        <fieldset class="farmer-organisation-fields" hidden>

        </fieldset>
        <fieldset class="input-seller-fields" hidden>

        </fieldset>
        <fieldset class="local-aggregator-fields" hidden>

        </fieldset>
        <fieldset class="agrodealer-fields" hidden>

        </fieldset>
    </div>
    <div class="col-md-12">
        <hr>
        <fieldset {{ (request()->is('*edit')) ? 'disabled' : '' }}>
            <legend>Other Information</legend>

            <div class="panel panel-default">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-user-firstname">First Name*</label>
                                <input name="user_firstname" id="trader-user-firstname" type="text" class="form-control {{ $errors->has('user_firstname') ? 'is-invalid' : '' }}" placeholder="Your First Name" value="{{ old('user_firstname', $trader->user->firstname ?? '') }}">

                                @if ($errors->has('user_firstname'))
                                    <div class="invalid-feedback">
                                        <strong>{{ $errors->first('user_firstname') }}</strong>
                                    </div>
                                @endif
                            </div> <!-- form-group end.// -->
                            <div class="col form-group">
                                <label for="trader-user-lastname">Last Name*</label>
                                <input name="user_lastname" id="trader-user-lastname" type="text" class="form-control {{ $errors->has('user_lastname') ? 'is-invalid' : '' }}" placeholder="Your Last Name" value="{{ old('user_lastname', $trader->user->lastname ?? '') }}">

                                @if ($errors->has('user_lastname'))
                                    <div class="invalid-feedback">
                                        <strong>{{ $errors->first('user_lastname') }}</strong>
                                    </div>
                                @endif
                            </div> <!-- form-group end.// -->
                        </div>
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-user-email">Email*</label>
                                <input name="user_email" id="trader-user-email" type="text" class="form-control {{ $errors->has('user_email') ? 'is-invalid' : '' }}" placeholder="Your Email" value="{{ old('user_email', $trader->user->email ?? '') }}">

                                @if ($errors->has('user_email'))
                                    <div class="invalid-feedback">
                                        <strong>{{ $errors->first('user_email') }}</strong>
                                    </div>
                                @endif
                            </div> <!-- form-group end.// -->

                            <div class="col form-group">
                                <label for="trader-user-phone">Phone Number*</label>
                                <input name="user_phone" id="trader-user-phone" type="text" class="form-control {{ $errors->has('user_phone') ? 'is-invalid' : '' }}" placeholder="Your Phone Number" value="{{ old('user_phone', $trader->user->phone ?? '') }}">

                                @if ($errors->has('user_phone'))
                                    <div class="invalid-feedback">
                                        <strong>{{ $errors->first('user_phone') }}</strong>
                                    </div>
                                @endif
                            </div> <!-- form-group end.// -->
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-user-username">Username*</label>
                                <input name="user_username" id="trader-user-username" type="text" class="form-control {{ $errors->has('user_username') ? 'is-invalid' : '' }}" placeholder="Your Username" value="{{ old('user_username', $trader->user->username ?? '') }}">

                                @if ($errors->has('user_username'))
                                    <div class="invalid-feedback">
                                        <strong>{{ $errors->first('user_username') }}</strong>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="col form-group">
                                <label for="trader-user-password">Password*</label>
                                <input name="user_password" id="trader-user-password" type="password" class="form-control {{ $errors->has('user_password') ? 'is-invalid' : '' }}" placeholder="Your Password">

                                @if ($errors->has('user_password'))
                                    <div class="invalid-feedback">
                                        <strong>{{ $errors->first('user_password') }}</strong>
                                    </div>
                                @endif
                            </div>
                            <div class="col form-group">
                                <label for="trader-user-password-confirm">Confirm Password*</label>
                                <input name="user_password_confirm" id="trader-user-password-confirm" type="password" class="form-control {{ $errors->has('user_password_confirm') ? 'is-invalid' : '' }}"  placeholder="Confirm Password">

                                @if ($errors->has('user_password_confirm'))
                                    <div class="invalid-feedback">
                                        <strong>{{ $errors->first('user_password_confirm') }}</strong>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>
    </div>
</div>
@section('scripts')    
     <script>
       
       $('#trader-type-id').on('change',function(){                       
                       
                          var el = document.getElementById('trader-type-id');
                          
                          var selectedText = el.options[el.selectedIndex].text;
                        
  
                          if(selectedText=="BTCotton Buyer"){
                           
                              $("#buyer_type_category").show();
                          }
                          else if(selectedText!="BTCotton Buyer"){
                              $("#buyer_type_category").hide();                             
                          }
                      
                      });
    </script>


@endsection
