<div id="order-panel" class="collapse order-panel mb-2">
    <div class="panel panel-default bg-light p-3">
        <div class="panel-body">
            <!-- form -->
            <form id="input-order-form" name="input-order-form" method="post">
                <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}">
                <input type="hidden" name="id" id="input-order-item-id">
                <input type="hidden" name="order_id" id="input-order-item-order-id" value="{{ $order->id }}">
                <input type="hidden" name="approved" id="input-order-item-approved" value="0">
                <input type="hidden" name="directed_to" id="input-order-item-directed-to">
                <input type="hidden" name="credited" id="input-order-item-credited">
                <input type="hidden" name="farmer_id" id="input-order-item-farmer-id-hidden" disabled>
                {{-- <input type="hidden" name="total" id="input-order-item-total" value="0"> --}}
                <div class="form-group row">
                    <div class="col-md-4">
                        <label for="trader-id">Farmer</label>
                        <select id="input-order-item-farmer-id" required name="farmer_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                            <option  value="">- Select -</option>
                            @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer())
                                @foreach($agfarmers as $farmer)
                                    <option value="{{ $farmer->user_id }}" data-username="{{$farmer->user->username}}"data-credit="{{$farmer->user->wallet->credit_limit}}" data-price="{{$farmer->user->wallet->float_bal}}">{{ $farmer->user->firstname }} {{ $farmer->user->lastname }} - {{ $farmer->user->phone }}</option>
                                @endforeach
                            @else
                                @foreach($farmers as $farmer)
                                    <option value="{{ $farmer->user_id }}" data-credit="{{$farmer->user->wallet->credit_limit}}" data-price="{{$farmer->user->wallet->float_bal}}">{{ $farmer->user->firstname }} {{ $farmer->user->lastname }} - {{ $farmer->user->phone }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="input-order-item-financing">Financing</label>
                        <input type="hidden" id="credit" class="form-control" value="0">
                        <input type="hidden" id="wallet" class="form-control" value="0">

                        <select id="input-order-item-financing" required name="financing" class="form-control select2" >
                            <option value="">- Select -</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="input-order-item-input-id">Filter Inputs...</label>
                        <select id="input-order-item-input-id" required name="input_id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                            <option value="">- Select -</option>
                            @if(Auth::user()->isTraderAdmin() && Auth::user()->getRelatedTrader()->isAgroDealer())
                            @foreach($inputsagro as $input)
                                <option value="{{ $input->id }}">{{ $input->name }}</option>
                            @endforeach
                            @else
                            @foreach($inputs as $input)
                                <option value="{{ $input->id }}">{{ $input->name }}</option>
                            @endforeach                                                                                                            @endif
                        </select>
                    </div>
                </div>
                <div class="form-group row">
                    <div class="col-md-4">
                        <label for="input-order-item-input-item-id">Supplier - Input</label>
                        <select required name="input_item_id" id="input-order-item-input-item-id" class="form-control" style="width: 100%; border-color: #ebedf2;">
                            <option value="">- Select -</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="input-order-item-quantity">Quantity <span id="input-order-selected-quantity"></span></label>
                        <input type="number" id="input-order-item-quantity" onkeyup="sum();" required name="quantity" class="form-control" >
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label for="input-order-item-price">Total Price</label>
                        <input type="hidden" name="price_per_unit" id="input-order-item-price" class="form-control">
                        <input type="number" name="price" id="input-order-item-total" class="form-control" value="0" readonly required onkeyup="sum();">
                        <div id="credited-amts"></div>
                    </div>
                    {{-- <div class="col-md-3">
                        <label for="input-order-item-expected-date">Expected Date</label>
                        <input type="date" onkeyup="checkPrice();" required name="expected_date" id="input-order-item-expected-date" class="form-control">
                    </div> --}}
                    {{-- <div class="col-md-3">
                        <label for="input-order-item-description">Description</label>
                        <textarea required name="description" onkeyup="checkPrice();" id="input-order-item-description" class="form-control" rows="1"></textarea>
                    </div> --}}
                </div>
                <div class="form-group row">
                    <div class="col-md-12" id="save-btn">
                        @if(Auth::user()->isAdmin() || Auth::user()->getRelatedTrader()->isFarmerOrganisation())
                            <button type="submit" id="input-order-item-save" class="btn btn-primary btn-round btn-sm" value="create-input-order-item"><i class="fas fa-check"></i> Save</button>
                        @else
                            <input type="hidden" id="user">
                            <input type="password" id="user1" placeholder="confirm PIN" class="form-control">
                            <button type="button" class="btn btn-info btn-round btn-sm" onclick="checkPrice();">Confirm</button>
                        @endif

                        <button type="reset" id="input-order-item-cancel" class="btn btn-danger btn-round btn-sm">Cancel</button>
                    </div>
                </div>
            </form><!-- endform -->
        </div>
    </div>
</div>
