<div id="filter-panel" class="collapse filter-panel mb-2">
    <div class="panel panel-default bg-light p-3">
        <div class="panel-body">
            <form id="traders-filter-form" class="form" role="form">
                <div class="row">
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-organisation-name">Farmer Organisation</label>
                        <input type="text" name="organisation_name" id="filter-organisation-name" class="form-control">
                    </div>
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-buyer">Buyer</label>
                        <input type="text" name="buyer" id="filter-buyer" class="form-control">
                    </div>
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-produce">Produce</label>
                        <select name="produce" id="filter-produce" class="form-control">
                            <option value="">All</option>
                            @foreach ($produces as $produce)
                                <option value="{{ $produce->id }}">{{ $produce->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-status">Status</label>
                        <select name="status" id="filter-status" class="form-control">
                            <option value="">All</option>
                            <option value="false">Pending</option>
                            <option value="1">Approved</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <button type="submit" id="filter-submit" class="btn btn-primary btn-round btn-sm">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                        <a href="{{ route('produce-collections.index') }}" class="btn btn-primary btn-round btn-border btn-sm">Clear</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

