<div id="filter-panel" class="collapse filter-panel mb-2">
    <div class="panel panel-default bg-light p-3">
        <div class="panel-body">
            <form id="input-order-items-filter-form" class="form" role="form">
                <div class="row">
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-farmer-name">Farmer Name</label>
                        <input type="text" name="farmer_name" id="filter-farmer-name" class="form-control">
                    </div>
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-seller-name">Seller Name</label>
                        <input type="text" name="seller_name" id="filter-seller-name" class="form-control">
                    </div>
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-input">Input</label>
                        <select name="input" id="filter-input" class="form-control">
                            <option value="">All</option>
                            @foreach ($inputs as $input)
                                <option value="{{ $input->id }}">{{ $input->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-xs-3 col-md-3">
                        {{-- 0 - Pending Financing, 1 - In Process, 2 - Completed, 3 - Delivered, 4 - Received --}}
                        <label class="control-label" for="filter-status">Status</label>
                        <select name="status" id="filter-status" class="form-control">
                            <option value="">All</option>
                            <option value="false">Pending Financing</option>
                            <option value="1">In Process</option>
                            <option value="2">Completed</option>
                            <option value="3">Delivered</option>
                            <option value="4">Received</option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-financing">Financing</label>
                        <select name="financing" id="filter-financing" class="form-control">
                            <option value="">All</option>
                            <option value="wallet">Wallet</option>
                            <option value="credit">Credit</option>
                        </select>
                    </div>
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-price-less-than">Price (Less Than)</label>
                        <input type="number" name="price_less_than" id="filter-price-less-than" class="form-control">
                    </div>
                    <div class="form-group col-xs-3 col-md-3">
                        <label class="control-label" for="filter-price-more-than">Price (More Than)</label>
                        <input type="number" name="price_more_than" id="filter-price-more-than" class="form-control">
                    </div>
                </div>
                <div class="row">
                    <div class="col">
                        <button type="submit" id="filter-submit" class="btn btn-primary btn-round btn-sm">
                            <i class="fas fa-filter"></i> Filter
                        </button>
                        <a href="{{ Request::url() }}" class="btn btn-primary btn-round btn-border btn-sm">Clear</a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

