<div class="row mt--2">
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-secondary mr-3">
                    <i class="far fa-building"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="{{ route('traders.index') }}">{{ $dashboard['statistics']['traders']['count'] }} Organisations</a></b></h5>
                    <small class="text-muted">{{ $dashboard['statistics']['traders']['last_week'] }} new registrations</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-danger mr-3">
                    <i class="fas fa-users-cog"></i>
                </span>
                <div>
                    {{-- {{dd($dashboard['statistics']['users'])}} --}}
                    <h5 class="mb-1"><b><a href="{{ route('users.index') }}">{{ $dashboard['statistics']['users']['count'] }} Users</a></b></h5>
                    <small class="text-muted">{{ $dashboard['statistics']['users']['last_week'] }} new registrations</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-success mr-3">
                    <i class="fas fa-layer-group"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="{{ route('produce-collections.index') }}">{{ $dashboard['statistics']['produce_orders']['count'] }} Collections</a></b></h5>
                    <small class="text-muted">{{ $dashboard['statistics']['produce_orders']['pending'] }} pending approval</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card p-3">
            <div class="d-flex align-items-center">
                <span class="stamp stamp-md bg-warning mr-3">
                    <i class="fas fa-cart-arrow-down"></i>
                </span>
                <div>
                    <h5 class="mb-1"><b><a href="{{ route('input_orders.index') }}">{{ $dashboard['statistics']['input_orders']['count'] }} Input Orders</a></b></h5>
                    <small class="text-muted">{{ $dashboard['statistics']['input_orders']['pending'] }} pending approval</small>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <div class="card-head-row">
                    <div class="card-title">Organisation Statistics</div>
                    {{-- <div class="card-tools">
                        <a href="#" class="btn btn-info btn-border btn-round btn-sm mr-2">
                            <i class="fa fa-pencil"></i>
                            Export
                        </a>
                    </div> --}}
                </div>
            </div>
            <div class="card-body">
                {!! $dashboard['trader_chart']->container() !!}
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card card-warning bg-warning-gradient">
            <div class="card-body">
                <h4 class="mt-3 b-b1 pb-2 mb-4 fw-bold">Quick Stats</h4>
                <h4 class="mt-0 pb-3 mb-0 fw-bold">Organisations</h4>
                <h1 class="mb-4 fw-bold">{{$dashboard['statistics']['traders']['count']}}</h1>

                <ul class="list-unstyled">
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>Farmer Organisations</small> <span>{{ $dashboard['counts']['fo'] }}</span></li>
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>BTCotton Buyers</small> <span>{{ $dashboard['counts']['bb'] }}</span></li>
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>BTCotton Input Sellers</small> <span>{{ $dashboard['counts']['bs'] }}</span></li>
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>Agrodealers</small> <span>{{ $dashboard['counts']['ad'] }}</span></li>
                    <li class="d-flex justify-content-between pb-1 pt-1"><small>Transporters</small> <span>{{ $dashboard['counts']['t'] }}</span></li>
                </ul>
                <hr>
                <div class="chart" style="max-height:150px;">
                    {!! $dashboard['trader_type_chart']->container() !!}
                </div>
            </div>
        </div>
    </div>
</div>
