<?php

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // $this->call(UsersTableSeeder::class);
        //factory(App\User::class, 10)->create();
        factory(App\Region::class, 10)->create();
        //factory(App\Trader::class, 10)->create();
        factory(App\Unit::class, 10)->create();
        factory(App\ProductCategory::class, 2)
            ->create()
            ->each(function($parentCat) {
                $parentCat->children()
                    ->saveMany(factory(App\ProductCategory::class, rand(2, 6))->make());
            });
        // factory(App\ProductCategory::class, 2)->states('child')->create();

        factory(App\Product::class, 10)->create()->each(function($prod) {
            $prod->items()
            ->saveMany(factory(App\Item::class, rand(1, 10))->make())
            ->each(function($invItem) {
                $invItem->stocks()
                ->saveMany(factory(App\Stock::class, rand(1, 5))->make());
            });
        });
    }
}
