<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductionCostsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('production_costs', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('input',100);
            $table->string('time',200);
            $table->double('cost',10,2);
            $table->string('details',255);
            $table->bigInteger('plan_id')->unsigned();
            $table->string('system')->nullable()->default('No');
            $table->timestamps();
            //foreigns
            $table->foreign('plan_id')->references('id')->on('farmer_busines_plans')->onUpdate('CASCADE')->onDelete('RESTRICT');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('production_costs', function (Blueprint $table) {
            $table->dropForeign('plan_id');
        });
        Schema::dropIfExists('production_costs');
    }
}
